<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Replace ServiceType
 * @subpackage Services
 */
class Replace extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReplaceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReplaceTemplate $parameters
     * @return \StructType\ReplaceTemplateResponse|bool
     */
    public function ReplaceTemplate(\StructType\ReplaceTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReplaceTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReplaceTemplateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
