<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDocument $parameters
     * @return \StructType\AddDocumentResponse|bool
     */
    public function AddDocument(\StructType\AddDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDocumentTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDocumentTemplate $parameters
     * @return \StructType\AddDocumentTemplateResponse|bool
     */
    public function AddDocumentTemplate(\StructType\AddDocumentTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDocumentTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDocumentTemplateEx
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDocumentTemplateEx $parameters
     * @return \StructType\AddDocumentTemplateExResponse|bool
     */
    public function AddDocumentTemplateEx(\StructType\AddDocumentTemplateEx $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDocumentTemplateEx($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddDocumentResponse|\StructType\AddDocumentTemplateExResponse|\StructType\AddDocumentTemplateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
