<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://testbox.a-trust.at/TestBox1/intern/HandySignaturPdf.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://testbox.a-trust.at/TestBox1/intern/HandySignaturPdf.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Start ServiceType
 */
$start = new \ServiceType\Start($options);
/**
 * Sample call for StartSignature operation/method
 */
if ($start->StartSignature(new \StructType\StartSignature()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Sample call for StartSignatureTemplate operation/method
 */
if ($start->StartSignatureTemplate(new \StructType\StartSignatureTemplate()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Sample call for StartSignatureTemplateEx operation/method
 */
if ($start->StartSignatureTemplateEx(new \StructType\StartSignatureTemplateEx()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Sample call for StartBatchSignature operation/method
 */
if ($start->StartBatchSignature(new \StructType\StartBatchSignature()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Samples for End ServiceType
 */
$end = new \ServiceType\End($options);
/**
 * Sample call for EndSignature operation/method
 */
if ($end->EndSignature(new \StructType\EndSignature()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Sample call for EndBatchSignature operation/method
 */
if ($end->EndBatchSignature(new \StructType\EndBatchSignature()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddDocument operation/method
 */
if ($add->AddDocument(new \StructType\AddDocument()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDocumentTemplate operation/method
 */
if ($add->AddDocumentTemplate(new \StructType\AddDocumentTemplate()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDocumentTemplateEx operation/method
 */
if ($add->AddDocumentTemplateEx(new \StructType\AddDocumentTemplateEx()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetDocument operation/method
 */
if ($get->GetDocument(new \StructType\GetDocument()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCertificate operation/method
 */
if ($get->GetCertificate(new \StructType\GetCertificate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTemplate operation/method
 */
if ($get->GetTemplate(new \StructType\GetTemplate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getWBPK operation/method
 */
if ($get->getWBPK(new \StructType\GetWBPK()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \ServiceType\Upload($options);
/**
 * Sample call for UploadTemplate operation/method
 */
if ($upload->UploadTemplate(new \StructType\UploadTemplate()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Replace ServiceType
 */
$replace = new \ServiceType\Replace($options);
/**
 * Sample call for ReplaceTemplate operation/method
 */
if ($replace->ReplaceTemplate(new \StructType\ReplaceTemplate()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteTemplate operation/method
 */
if ($delete->DeleteTemplate(new \StructType\DeleteTemplate()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
/**
 * Sample call for ListTemplate operation/method
 */
if ($list->ListTemplate(new \StructType\ListTemplate()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Do ServiceType
 */
$do = new \ServiceType\_Do($options);
/**
 * Sample call for DoP12Signature operation/method
 */
if ($do->DoP12Signature(new \StructType\DoP12Signature()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Sample call for DoP12SignatureTemplate operation/method
 */
if ($do->DoP12SignatureTemplate(new \StructType\DoP12SignatureTemplate()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Sample call for DoP12SignatureTemplateEx operation/method
 */
if ($do->DoP12SignatureTemplateEx(new \StructType\DoP12SignatureTemplateEx()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
