<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTemplateResponse StructType
 * @subpackage Structs
 */
class GetTemplateResponse extends AbstractStructBase
{
    /**
     * The GetTemplateResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GetTemplateResult;
    /**
     * The TemplateData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TemplateData;
    /**
     * Constructor method for GetTemplateResponse
     * @uses GetTemplateResponse::setGetTemplateResult()
     * @uses GetTemplateResponse::setTemplateData()
     * @param int $getTemplateResult
     * @param string $templateData
     */
    public function __construct($getTemplateResult = null, $templateData = null)
    {
        $this
            ->setGetTemplateResult($getTemplateResult)
            ->setTemplateData($templateData);
    }
    /**
     * Get GetTemplateResult value
     * @return int|null
     */
    public function getGetTemplateResult()
    {
        return $this->GetTemplateResult;
    }
    /**
     * Set GetTemplateResult value
     * @param int $getTemplateResult
     * @return \StructType\GetTemplateResponse
     */
    public function setGetTemplateResult($getTemplateResult = null)
    {
        // validation for constraint: int
        if (!is_null($getTemplateResult) && !(is_int($getTemplateResult) || ctype_digit($getTemplateResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($getTemplateResult, true), gettype($getTemplateResult)), __LINE__);
        }
        $this->GetTemplateResult = $getTemplateResult;
        return $this;
    }
    /**
     * Get TemplateData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTemplateData()
    {
        return isset($this->TemplateData) ? $this->TemplateData : null;
    }
    /**
     * Set TemplateData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $templateData
     * @return \StructType\GetTemplateResponse
     */
    public function setTemplateData($templateData = null)
    {
        // validation for constraint: string
        if (!is_null($templateData) && !is_string($templateData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateData, true), gettype($templateData)), __LINE__);
        }
        if (is_null($templateData) || (is_array($templateData) && empty($templateData))) {
            unset($this->TemplateData);
        } else {
            $this->TemplateData = $templateData;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTemplateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
