<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCertificateResponse StructType
 * @subpackage Structs
 */
class GetCertificateResponse extends AbstractStructBase
{
    /**
     * The GetCertificateResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GetCertificateResult;
    /**
     * The CertificateB64
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CertificateB64;
    /**
     * Constructor method for GetCertificateResponse
     * @uses GetCertificateResponse::setGetCertificateResult()
     * @uses GetCertificateResponse::setCertificateB64()
     * @param int $getCertificateResult
     * @param string $certificateB64
     */
    public function __construct($getCertificateResult = null, $certificateB64 = null)
    {
        $this
            ->setGetCertificateResult($getCertificateResult)
            ->setCertificateB64($certificateB64);
    }
    /**
     * Get GetCertificateResult value
     * @return int|null
     */
    public function getGetCertificateResult()
    {
        return $this->GetCertificateResult;
    }
    /**
     * Set GetCertificateResult value
     * @param int $getCertificateResult
     * @return \StructType\GetCertificateResponse
     */
    public function setGetCertificateResult($getCertificateResult = null)
    {
        // validation for constraint: int
        if (!is_null($getCertificateResult) && !(is_int($getCertificateResult) || ctype_digit($getCertificateResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($getCertificateResult, true), gettype($getCertificateResult)), __LINE__);
        }
        $this->GetCertificateResult = $getCertificateResult;
        return $this;
    }
    /**
     * Get CertificateB64 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCertificateB64()
    {
        return isset($this->CertificateB64) ? $this->CertificateB64 : null;
    }
    /**
     * Set CertificateB64 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $certificateB64
     * @return \StructType\GetCertificateResponse
     */
    public function setCertificateB64($certificateB64 = null)
    {
        // validation for constraint: string
        if (!is_null($certificateB64) && !is_string($certificateB64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificateB64, true), gettype($certificateB64)), __LINE__);
        }
        if (is_null($certificateB64) || (is_array($certificateB64) && empty($certificateB64))) {
            unset($this->CertificateB64);
        } else {
            $this->CertificateB64 = $certificateB64;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCertificateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
