<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndBatchSignature StructType
 * @subpackage Structs
 */
class EndBatchSignature extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $APIKey;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ticket;
    /**
     * The HandySignaturParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandySignaturParameter;
    /**
     * Constructor method for EndBatchSignature
     * @uses EndBatchSignature::setAPIKey()
     * @uses EndBatchSignature::setTicket()
     * @uses EndBatchSignature::setHandySignaturParameter()
     * @param string $aPIKey
     * @param string $ticket
     * @param string $handySignaturParameter
     */
    public function __construct($aPIKey = null, $ticket = null, $handySignaturParameter = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setTicket($ticket)
            ->setHandySignaturParameter($handySignaturParameter);
    }
    /**
     * Get APIKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAPIKey()
    {
        return isset($this->APIKey) ? $this->APIKey : null;
    }
    /**
     * Set APIKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aPIKey
     * @return \StructType\EndBatchSignature
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPIKey, true), gettype($aPIKey)), __LINE__);
        }
        if (is_null($aPIKey) || (is_array($aPIKey) && empty($aPIKey))) {
            unset($this->APIKey);
        } else {
            $this->APIKey = $aPIKey;
        }
        return $this;
    }
    /**
     * Get Ticket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicket()
    {
        return isset($this->Ticket) ? $this->Ticket : null;
    }
    /**
     * Set Ticket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticket
     * @return \StructType\EndBatchSignature
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        if (is_null($ticket) || (is_array($ticket) && empty($ticket))) {
            unset($this->Ticket);
        } else {
            $this->Ticket = $ticket;
        }
        return $this;
    }
    /**
     * Get HandySignaturParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandySignaturParameter()
    {
        return isset($this->HandySignaturParameter) ? $this->HandySignaturParameter : null;
    }
    /**
     * Set HandySignaturParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handySignaturParameter
     * @return \StructType\EndBatchSignature
     */
    public function setHandySignaturParameter($handySignaturParameter = null)
    {
        // validation for constraint: string
        if (!is_null($handySignaturParameter) && !is_string($handySignaturParameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handySignaturParameter, true), gettype($handySignaturParameter)), __LINE__);
        }
        if (is_null($handySignaturParameter) || (is_array($handySignaturParameter) && empty($handySignaturParameter))) {
            unset($this->HandySignaturParameter);
        } else {
            $this->HandySignaturParameter = $handySignaturParameter;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EndBatchSignature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
