<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Start ServiceType
 * @subpackage Services
 */
class Start extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named StartSignature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StartSignature $parameters
     * @return \StructType\StartSignatureResponse|bool
     */
    public function StartSignature(\StructType\StartSignature $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StartSignature($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StartSignatureTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StartSignatureTemplate $parameters
     * @return \StructType\StartSignatureTemplateResponse|bool
     */
    public function StartSignatureTemplate(\StructType\StartSignatureTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StartSignatureTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StartSignatureTemplateEx
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StartSignatureTemplateEx $parameters
     * @return \StructType\StartSignatureTemplateExResponse|bool
     */
    public function StartSignatureTemplateEx(\StructType\StartSignatureTemplateEx $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StartSignatureTemplateEx($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StartBatchSignature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StartBatchSignature $parameters
     * @return \StructType\StartBatchSignatureResponse|bool
     */
    public function StartBatchSignature(\StructType\StartBatchSignature $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StartBatchSignature($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StartBatchSignatureResponse|\StructType\StartSignatureResponse|\StructType\StartSignatureTemplateExResponse|\StructType\StartSignatureTemplateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
