<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Switch ServiceType
 * @subpackage Services
 */
class _Switch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named switchOrderEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SwitchOrderEntry $parameters
     * @return \StructType\SwitchOrderEntryResponse|bool
     */
    public function switchOrderEntry(\StructType\SwitchOrderEntry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->switchOrderEntry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named switchOrderEntryParam
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SwitchOrderEntryParam $parameters
     * @return \StructType\SwitchOrderEntryParamResponse|bool
     */
    public function switchOrderEntryParam(\StructType\SwitchOrderEntryParam $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->switchOrderEntryParam($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SwitchOrderEntryParamResponse|\StructType\SwitchOrderEntryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
