<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Xsip ServiceType
 * @subpackage Services
 */
class Xsip extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named xsipOrderEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XsipOrderEntry $parameters
     * @return \StructType\XsipOrderEntryResponse|bool
     */
    public function xsipOrderEntry(\StructType\XsipOrderEntry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->xsipOrderEntry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named xsipOrderEntryParam
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XsipOrderEntryParam $parameters
     * @return \StructType\XsipOrderEntryParamResponse|bool
     */
    public function xsipOrderEntryParam(\StructType\XsipOrderEntryParam $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->xsipOrderEntryParam($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\XsipOrderEntryParamResponse|\StructType\XsipOrderEntryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
