<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sip ServiceType
 * @subpackage Services
 */
class Sip extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sipOrderEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SipOrderEntry $parameters
     * @return \StructType\SipOrderEntryResponse|bool
     */
    public function sipOrderEntry(\StructType\SipOrderEntry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sipOrderEntry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sipOrderEntryParam
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SipOrderEntryParam $parameters
     * @return \StructType\SipOrderEntryParamResponse|bool
     */
    public function sipOrderEntryParam(\StructType\SipOrderEntryParam $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sipOrderEntryParam($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SipOrderEntryParamResponse|\StructType\SipOrderEntryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
