<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Spread ServiceType
 * @subpackage Services
 */
class Spread extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named spreadOrderEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SpreadOrderEntry $parameters
     * @return \StructType\SpreadOrderEntryResponse|bool
     */
    public function spreadOrderEntry(\StructType\SpreadOrderEntry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->spreadOrderEntry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named spreadOrderEntryParam
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SpreadOrderEntryParam $parameters
     * @return \StructType\SpreadOrderEntryParamResponse|bool
     */
    public function spreadOrderEntryParam(\StructType\SpreadOrderEntryParam $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->spreadOrderEntryParam($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SpreadOrderEntryParamResponse|\StructType\SpreadOrderEntryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
