<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MFAPI StructType
 * @subpackage Structs
 */
class MFAPI extends AbstractStructBase
{
    /**
     * The Flag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Flag;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserId;
    /**
     * The EncryptedPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EncryptedPassword;
    /**
     * The param
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $param;
    /**
     * Constructor method for MFAPI
     * @uses MFAPI::setFlag()
     * @uses MFAPI::setUserId()
     * @uses MFAPI::setEncryptedPassword()
     * @uses MFAPI::setParam()
     * @param string $flag
     * @param string $userId
     * @param string $encryptedPassword
     * @param string $param
     */
    public function __construct($flag = null, $userId = null, $encryptedPassword = null, $param = null)
    {
        $this
            ->setFlag($flag)
            ->setUserId($userId)
            ->setEncryptedPassword($encryptedPassword)
            ->setParam($param);
    }
    /**
     * Get Flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlag()
    {
        return isset($this->Flag) ? $this->Flag : null;
    }
    /**
     * Set Flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flag
     * @return \StructType\MFAPI
     */
    public function setFlag($flag = null)
    {
        // validation for constraint: string
        if (!is_null($flag) && !is_string($flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flag, true), gettype($flag)), __LINE__);
        }
        if (is_null($flag) || (is_array($flag) && empty($flag))) {
            unset($this->Flag);
        } else {
            $this->Flag = $flag;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \StructType\MFAPI
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get EncryptedPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEncryptedPassword()
    {
        return isset($this->EncryptedPassword) ? $this->EncryptedPassword : null;
    }
    /**
     * Set EncryptedPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $encryptedPassword
     * @return \StructType\MFAPI
     */
    public function setEncryptedPassword($encryptedPassword = null)
    {
        // validation for constraint: string
        if (!is_null($encryptedPassword) && !is_string($encryptedPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encryptedPassword, true), gettype($encryptedPassword)), __LINE__);
        }
        if (is_null($encryptedPassword) || (is_array($encryptedPassword) && empty($encryptedPassword))) {
            unset($this->EncryptedPassword);
        } else {
            $this->EncryptedPassword = $encryptedPassword;
        }
        return $this;
    }
    /**
     * Get param value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParam()
    {
        return isset($this->param) ? $this->param : null;
    }
    /**
     * Set param value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $param
     * @return \StructType\MFAPI
     */
    public function setParam($param = null)
    {
        // validation for constraint: string
        if (!is_null($param) && !is_string($param)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($param, true), gettype($param)), __LINE__);
        }
        if (is_null($param) || (is_array($param) && empty($param))) {
            unset($this->param);
        } else {
            $this->param = $param;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MFAPI
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
