<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for MFAPI ServiceType
 * @subpackage Services
 */
class MFAPI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MFAPI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MFAPI $parameters
     * @return \StructType\MFAPIResponse|bool
     */
    public function MFAPI(\StructType\MFAPI $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MFAPI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MFAPIResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
