<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCurrencies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrenciesRequestBody $getCurrencies
     * @return \StructType\GetCurrenciesResponseBody|bool
     */
    public function GetCurrencies(\StructType\GetCurrenciesRequestBody $getCurrencies)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCurrencies($getCurrencies));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrencyUnits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrencyUnitsRequestBody $getCurrencyUnits
     * @return \StructType\GetCurrencyUnitsResponseBody|bool
     */
    public function GetCurrencyUnits(\StructType\GetCurrencyUnitsRequestBody $getCurrencyUnits)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCurrencyUnits($getCurrencyUnits));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrentExchangeRates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrentExchangeRatesRequestBody $getCurrentExchangeRates
     * @return \StructType\GetCurrentExchangeRatesResponseBody|bool
     */
    public function GetCurrentExchangeRates(\StructType\GetCurrentExchangeRatesRequestBody $getCurrentExchangeRates)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCurrentExchangeRates($getCurrentExchangeRates));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDateInterval
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDateIntervalRequestBody $getDateInterval
     * @return \StructType\GetDateIntervalResponseBody|bool
     */
    public function GetDateInterval(\StructType\GetDateIntervalRequestBody $getDateInterval)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDateInterval($getDateInterval));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExchangeRates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExchangeRatesRequestBody $getExchangeRates
     * @return \StructType\GetExchangeRatesResponseBody|bool
     */
    public function GetExchangeRates(\StructType\GetExchangeRatesRequestBody $getExchangeRates)
    {
        try {
            $this->setResult(self::getSoapClient()->GetExchangeRates($getExchangeRates));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInfoRequestBody $getInfo
     * @return \StructType\GetInfoResponseBody|bool
     */
    public function GetInfo(\StructType\GetInfoRequestBody $getInfo)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInfo($getInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCurrenciesResponseBody|\StructType\GetCurrencyUnitsResponseBody|\StructType\GetCurrentExchangeRatesResponseBody|\StructType\GetDateIntervalResponseBody|\StructType\GetExchangeRatesResponseBody|\StructType\GetInfoResponseBody
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
