<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelarCFDI StructType
 * Meta information extracted from the WSDL
 * - type: tns:CancelarCFDI
 * @subpackage Structs
 */
class CancelarCFDI extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The contrasenia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contrasenia;
    /**
     * The idServicio
     * @var int
     */
    public $idServicio;
    /**
     * The xml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $xml;
    /**
     * The certificado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $certificado;
    /**
     * The RSAPK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RSAPK;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * Constructor method for CancelarCFDI
     * @uses CancelarCFDI::setUsuario()
     * @uses CancelarCFDI::setContrasenia()
     * @uses CancelarCFDI::setIdServicio()
     * @uses CancelarCFDI::setXml()
     * @uses CancelarCFDI::setCertificado()
     * @uses CancelarCFDI::setRSAPK()
     * @uses CancelarCFDI::setEmail()
     * @param string $usuario
     * @param string $contrasenia
     * @param int $idServicio
     * @param string $xml
     * @param string $certificado
     * @param string $rSAPK
     * @param string $email
     */
    public function __construct($usuario = null, $contrasenia = null, $idServicio = null, $xml = null, $certificado = null, $rSAPK = null, $email = null)
    {
        $this
            ->setUsuario($usuario)
            ->setContrasenia($contrasenia)
            ->setIdServicio($idServicio)
            ->setXml($xml)
            ->setCertificado($certificado)
            ->setRSAPK($rSAPK)
            ->setEmail($email);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\CancelarCFDI
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get contrasenia value
     * @return string|null
     */
    public function getContrasenia()
    {
        return $this->contrasenia;
    }
    /**
     * Set contrasenia value
     * @param string $contrasenia
     * @return \StructType\CancelarCFDI
     */
    public function setContrasenia($contrasenia = null)
    {
        // validation for constraint: string
        if (!is_null($contrasenia) && !is_string($contrasenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrasenia, true), gettype($contrasenia)), __LINE__);
        }
        $this->contrasenia = $contrasenia;
        return $this;
    }
    /**
     * Get idServicio value
     * @return int|null
     */
    public function getIdServicio()
    {
        return $this->idServicio;
    }
    /**
     * Set idServicio value
     * @param int $idServicio
     * @return \StructType\CancelarCFDI
     */
    public function setIdServicio($idServicio = null)
    {
        // validation for constraint: int
        if (!is_null($idServicio) && !(is_int($idServicio) || ctype_digit($idServicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idServicio, true), gettype($idServicio)), __LINE__);
        }
        $this->idServicio = $idServicio;
        return $this;
    }
    /**
     * Get xml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXml()
    {
        return isset($this->xml) ? $this->xml : null;
    }
    /**
     * Set xml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xml
     * @return \StructType\CancelarCFDI
     */
    public function setXml($xml = null)
    {
        // validation for constraint: string
        if (!is_null($xml) && !is_string($xml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xml, true), gettype($xml)), __LINE__);
        }
        if (is_null($xml) || (is_array($xml) && empty($xml))) {
            unset($this->xml);
        } else {
            $this->xml = $xml;
        }
        return $this;
    }
    /**
     * Get certificado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCertificado()
    {
        return isset($this->certificado) ? $this->certificado : null;
    }
    /**
     * Set certificado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $certificado
     * @return \StructType\CancelarCFDI
     */
    public function setCertificado($certificado = null)
    {
        // validation for constraint: string
        if (!is_null($certificado) && !is_string($certificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificado, true), gettype($certificado)), __LINE__);
        }
        if (is_null($certificado) || (is_array($certificado) && empty($certificado))) {
            unset($this->certificado);
        } else {
            $this->certificado = $certificado;
        }
        return $this;
    }
    /**
     * Get RSAPK value
     * @return string|null
     */
    public function getRSAPK()
    {
        return $this->RSAPK;
    }
    /**
     * Set RSAPK value
     * @param string $rSAPK
     * @return \StructType\CancelarCFDI
     */
    public function setRSAPK($rSAPK = null)
    {
        // validation for constraint: string
        if (!is_null($rSAPK) && !is_string($rSAPK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rSAPK, true), gettype($rSAPK)), __LINE__);
        }
        $this->RSAPK = $rSAPK;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CancelarCFDI
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelarCFDI
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
