<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AceptarRechazarCancelacionCA StructType
 * Meta information extracted from the WSDL
 * - type: tns:AceptarRechazarCancelacionCA
 * @subpackage Structs
 */
class AceptarRechazarCancelacionCA extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The contrasenia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contrasenia;
    /**
     * The idServicio
     * @var int
     */
    public $idServicio;
    /**
     * The RfcReceptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RfcReceptor;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Uuid[]
     */
    public $UUID;
    /**
     * Constructor method for AceptarRechazarCancelacionCA
     * @uses AceptarRechazarCancelacionCA::setUsuario()
     * @uses AceptarRechazarCancelacionCA::setContrasenia()
     * @uses AceptarRechazarCancelacionCA::setIdServicio()
     * @uses AceptarRechazarCancelacionCA::setRfcReceptor()
     * @uses AceptarRechazarCancelacionCA::setUUID()
     * @param string $usuario
     * @param string $contrasenia
     * @param int $idServicio
     * @param string $rfcReceptor
     * @param \StructType\Uuid[] $uUID
     */
    public function __construct($usuario = null, $contrasenia = null, $idServicio = null, $rfcReceptor = null, array $uUID = array())
    {
        $this
            ->setUsuario($usuario)
            ->setContrasenia($contrasenia)
            ->setIdServicio($idServicio)
            ->setRfcReceptor($rfcReceptor)
            ->setUUID($uUID);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\AceptarRechazarCancelacionCA
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get contrasenia value
     * @return string|null
     */
    public function getContrasenia()
    {
        return $this->contrasenia;
    }
    /**
     * Set contrasenia value
     * @param string $contrasenia
     * @return \StructType\AceptarRechazarCancelacionCA
     */
    public function setContrasenia($contrasenia = null)
    {
        // validation for constraint: string
        if (!is_null($contrasenia) && !is_string($contrasenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrasenia, true), gettype($contrasenia)), __LINE__);
        }
        $this->contrasenia = $contrasenia;
        return $this;
    }
    /**
     * Get idServicio value
     * @return int|null
     */
    public function getIdServicio()
    {
        return $this->idServicio;
    }
    /**
     * Set idServicio value
     * @param int $idServicio
     * @return \StructType\AceptarRechazarCancelacionCA
     */
    public function setIdServicio($idServicio = null)
    {
        // validation for constraint: int
        if (!is_null($idServicio) && !(is_int($idServicio) || ctype_digit($idServicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idServicio, true), gettype($idServicio)), __LINE__);
        }
        $this->idServicio = $idServicio;
        return $this;
    }
    /**
     * Get RfcReceptor value
     * @return string|null
     */
    public function getRfcReceptor()
    {
        return $this->RfcReceptor;
    }
    /**
     * Set RfcReceptor value
     * @param string $rfcReceptor
     * @return \StructType\AceptarRechazarCancelacionCA
     */
    public function setRfcReceptor($rfcReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($rfcReceptor) && !is_string($rfcReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfcReceptor, true), gettype($rfcReceptor)), __LINE__);
        }
        $this->RfcReceptor = $rfcReceptor;
        return $this;
    }
    /**
     * Get UUID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Uuid[]|null
     */
    public function getUUID()
    {
        return isset($this->UUID) ? $this->UUID : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUUID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUUID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUUIDForArrayConstraintsFromSetUUID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aceptarRechazarCancelacionCAUUIDItem) {
            // validation for constraint: itemType
            if (!$aceptarRechazarCancelacionCAUUIDItem instanceof \StructType\Uuid) {
                $invalidValues[] = is_object($aceptarRechazarCancelacionCAUUIDItem) ? get_class($aceptarRechazarCancelacionCAUUIDItem) : sprintf('%s(%s)', gettype($aceptarRechazarCancelacionCAUUIDItem), var_export($aceptarRechazarCancelacionCAUUIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UUID property can only contain items of type \StructType\Uuid, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UUID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Uuid[] $uUID
     * @return \StructType\AceptarRechazarCancelacionCA
     */
    public function setUUID(array $uUID = array())
    {
        // validation for constraint: array
        if ('' !== ($uUIDArrayErrorMessage = self::validateUUIDForArrayConstraintsFromSetUUID($uUID))) {
            throw new \InvalidArgumentException($uUIDArrayErrorMessage, __LINE__);
        }
        if (is_null($uUID) || (is_array($uUID) && empty($uUID))) {
            unset($this->UUID);
        } else {
            $this->UUID = $uUID;
        }
        return $this;
    }
    /**
     * Add item to UUID value
     * @throws \InvalidArgumentException
     * @param \StructType\Uuid $item
     * @return \StructType\AceptarRechazarCancelacionCA
     */
    public function addToUUID(\StructType\Uuid $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Uuid) {
            throw new \InvalidArgumentException(sprintf('The UUID property can only contain items of type \StructType\Uuid, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UUID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AceptarRechazarCancelacionCA
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
