<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelarCFDICA StructType
 * Meta information extracted from the WSDL
 * - type: tns:CancelarCFDICA
 * @subpackage Structs
 * @version https
 */
class CancelarCFDICA extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The contrasenia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contrasenia;
    /**
     * The idServicio
     * @var int
     */
    public $idServicio;
    /**
     * The xml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $xml;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * Constructor method for CancelarCFDICA
     * @uses CancelarCFDICA::setUsuario()
     * @uses CancelarCFDICA::setContrasenia()
     * @uses CancelarCFDICA::setIdServicio()
     * @uses CancelarCFDICA::setXml()
     * @uses CancelarCFDICA::setEmail()
     * @param string $usuario
     * @param string $contrasenia
     * @param int $idServicio
     * @param string $xml
     * @param string $email
     */
    public function __construct($usuario = null, $contrasenia = null, $idServicio = null, $xml = null, $email = null)
    {
        $this
            ->setUsuario($usuario)
            ->setContrasenia($contrasenia)
            ->setIdServicio($idServicio)
            ->setXml($xml)
            ->setEmail($email);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\CancelarCFDICA
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get contrasenia value
     * @return string|null
     */
    public function getContrasenia()
    {
        return $this->contrasenia;
    }
    /**
     * Set contrasenia value
     * @param string $contrasenia
     * @return \StructType\CancelarCFDICA
     */
    public function setContrasenia($contrasenia = null)
    {
        // validation for constraint: string
        if (!is_null($contrasenia) && !is_string($contrasenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrasenia, true), gettype($contrasenia)), __LINE__);
        }
        $this->contrasenia = $contrasenia;
        return $this;
    }
    /**
     * Get idServicio value
     * @return int|null
     */
    public function getIdServicio()
    {
        return $this->idServicio;
    }
    /**
     * Set idServicio value
     * @param int $idServicio
     * @return \StructType\CancelarCFDICA
     */
    public function setIdServicio($idServicio = null)
    {
        // validation for constraint: int
        if (!is_null($idServicio) && !(is_int($idServicio) || ctype_digit($idServicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idServicio, true), gettype($idServicio)), __LINE__);
        }
        $this->idServicio = $idServicio;
        return $this;
    }
    /**
     * Get xml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXml()
    {
        return isset($this->xml) ? $this->xml : null;
    }
    /**
     * Set xml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xml
     * @return \StructType\CancelarCFDICA
     */
    public function setXml($xml = null)
    {
        // validation for constraint: string
        if (!is_null($xml) && !is_string($xml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xml, true), gettype($xml)), __LINE__);
        }
        if (is_null($xml) || (is_array($xml) && empty($xml))) {
            unset($this->xml);
        } else {
            $this->xml = $xml;
        }
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CancelarCFDICA
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelarCFDICA
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
