<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://cancelacion.facturehoy.com/CancelacionCFDI33/WsCancelacionCFDIOtroPAC33?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://cancelacion.facturehoy.com/CancelacionCFDI33/WsCancelacionCFDIOtroPAC33?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancelar ServiceType
 */
$cancelar = new \ServiceType\Cancelar($options);
/**
 * Sample call for CancelarCFDIOtroPac operation/method
 */
if ($cancelar->CancelarCFDIOtroPac(new \StructType\CancelarCFDI()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Sample call for CancelarCFDICAOtroPac operation/method
 */
if ($cancelar->CancelarCFDICAOtroPac(new \StructType\CancelarCFDICA()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Samples for Aceptar ServiceType
 */
$aceptar = new \ServiceType\Aceptar($options);
/**
 * Sample call for AceptarRechazarCancelacionOtroPac operation/method
 */
if ($aceptar->AceptarRechazarCancelacionOtroPac(new \StructType\AceptarRechazarCancelacion()) !== false) {
    print_r($aceptar->getResult());
} else {
    print_r($aceptar->getLastError());
}
/**
 * Sample call for AceptarRechazarCancelacionCAOtroPac operation/method
 */
if ($aceptar->AceptarRechazarCancelacionCAOtroPac(new \StructType\AceptarRechazarCancelacionCA()) !== false) {
    print_r($aceptar->getResult());
} else {
    print_r($aceptar->getLastError());
}
