<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancelar ServiceType
 * @subpackage Services
 * @version https
 */
class Cancelar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelarCFDIOtroPac
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelarCFDI $parameters
     * @return \StructType\CancelarCFDIResponse|bool
     */
    public function CancelarCFDIOtroPac(\StructType\CancelarCFDI $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelarCFDIOtroPac($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelarCFDICAOtroPac
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelarCFDICA $parameters
     * @return \StructType\CancelarCFDICAResponse|bool
     */
    public function CancelarCFDICAOtroPac(\StructType\CancelarCFDICA $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelarCFDICAOtroPac($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelarCFDICAResponse|\StructType\CancelarCFDIResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
