<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.yurticikargo.com:8080/KOPSWebServices/ShippingOrderDispatcherServices?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.yurticikargo.com:8080/KOPSWebServices/ShippingOrderDispatcherServices?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for cancelReturnShipmentCode operation/method
 */
if ($cancel->cancelReturnShipmentCode(new \StructType\CancelReturnShipmentCode()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for cancelShipment operation/method
 */
if ($cancel->cancelShipment(new \StructType\CancelShipment()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createShipment operation/method
 */
if ($create->createShipment(new \StructType\CreateShipment()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createShipmentDetail operation/method
 */
if ($create->createShipmentDetail(new \StructType\CreateShipmentDetail()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \ServiceType\Query($options);
/**
 * Sample call for queryShipment operation/method
 */
if ($query->queryShipment(new \StructType\QueryShipment()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryShipmentDetail operation/method
 */
if ($query->queryShipmentDetail(new \StructType\QueryShipmentDetail()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for saveReturnShipmentCode operation/method
 */
if ($save->saveReturnShipmentCode(new \StructType\SaveReturnShipmentCode()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
