<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancelReturnShipmentCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelReturnShipmentCode $cancelReturnShipmentCode
     * @return \StructType\CancelReturnShipmentCodeResponse|bool
     */
    public function cancelReturnShipmentCode(\StructType\CancelReturnShipmentCode $cancelReturnShipmentCode)
    {
        try {
            $this->setResult($this->getSoapClient()->cancelReturnShipmentCode($cancelReturnShipmentCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cancelShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelShipment $cancelShipment
     * @return \StructType\CancelShipmentResponse|bool
     */
    public function cancelShipment(\StructType\CancelShipment $cancelShipment)
    {
        try {
            $this->setResult($this->getSoapClient()->cancelShipment($cancelShipment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelReturnShipmentCodeResponse|\StructType\CancelShipmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
