<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingOrderResultVO StructType
 * @subpackage Structs
 */
class ShippingOrderResultVO extends ExtendedBaseResultVO
{
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * The jobId
     * @var int
     */
    public $jobId;
    /**
     * The shippingOrderDetailVO
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShippingOrderDetailVO[]
     */
    public $shippingOrderDetailVO;
    /**
     * Constructor method for shippingOrderResultVO
     * @uses ShippingOrderResultVO::setCount()
     * @uses ShippingOrderResultVO::setJobId()
     * @uses ShippingOrderResultVO::setShippingOrderDetailVO()
     * @param int $count
     * @param int $jobId
     * @param \StructType\ShippingOrderDetailVO[] $shippingOrderDetailVO
     */
    public function __construct($count = null, $jobId = null, array $shippingOrderDetailVO = array())
    {
        $this
            ->setCount($count)
            ->setJobId($jobId)
            ->setShippingOrderDetailVO($shippingOrderDetailVO);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\ShippingOrderResultVO
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get jobId value
     * @return int|null
     */
    public function getJobId()
    {
        return $this->jobId;
    }
    /**
     * Set jobId value
     * @param int $jobId
     * @return \StructType\ShippingOrderResultVO
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: int
        if (!is_null($jobId) && !(is_int($jobId) || ctype_digit($jobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->jobId = $jobId;
        return $this;
    }
    /**
     * Get shippingOrderDetailVO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShippingOrderDetailVO[]|null
     */
    public function getShippingOrderDetailVO()
    {
        return isset($this->shippingOrderDetailVO) ? $this->shippingOrderDetailVO : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingOrderDetailVO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingOrderDetailVO method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingOrderDetailVOForArrayConstraintsFromSetShippingOrderDetailVO(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingOrderResultVOShippingOrderDetailVOItem) {
            // validation for constraint: itemType
            if (!$shippingOrderResultVOShippingOrderDetailVOItem instanceof \StructType\ShippingOrderDetailVO) {
                $invalidValues[] = is_object($shippingOrderResultVOShippingOrderDetailVOItem) ? get_class($shippingOrderResultVOShippingOrderDetailVOItem) : sprintf('%s(%s)', gettype($shippingOrderResultVOShippingOrderDetailVOItem), var_export($shippingOrderResultVOShippingOrderDetailVOItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shippingOrderDetailVO property can only contain items of type \StructType\ShippingOrderDetailVO, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shippingOrderDetailVO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingOrderDetailVO[] $shippingOrderDetailVO
     * @return \StructType\ShippingOrderResultVO
     */
    public function setShippingOrderDetailVO(array $shippingOrderDetailVO = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingOrderDetailVOArrayErrorMessage = self::validateShippingOrderDetailVOForArrayConstraintsFromSetShippingOrderDetailVO($shippingOrderDetailVO))) {
            throw new \InvalidArgumentException($shippingOrderDetailVOArrayErrorMessage, __LINE__);
        }
        if (is_null($shippingOrderDetailVO) || (is_array($shippingOrderDetailVO) && empty($shippingOrderDetailVO))) {
            unset($this->shippingOrderDetailVO);
        } else {
            $this->shippingOrderDetailVO = $shippingOrderDetailVO;
        }
        return $this;
    }
    /**
     * Add item to shippingOrderDetailVO value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingOrderDetailVO $item
     * @return \StructType\ShippingOrderResultVO
     */
    public function addToShippingOrderDetailVO(\StructType\ShippingOrderDetailVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShippingOrderDetailVO) {
            throw new \InvalidArgumentException(sprintf('The shippingOrderDetailVO property can only contain items of type \StructType\ShippingOrderDetailVO, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shippingOrderDetailVO[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingOrderResultVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
