<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingDeliveryResultVO StructType
 * @subpackage Structs
 */
class ShippingDeliveryResultVO extends ExtendedBaseResultVO
{
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * The senderCustId
     * @var int
     */
    public $senderCustId;
    /**
     * The shippingDeliveryDetailVO
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShippingDeliveryDetailVO[]
     */
    public $shippingDeliveryDetailVO;
    /**
     * Constructor method for shippingDeliveryResultVO
     * @uses ShippingDeliveryResultVO::setCount()
     * @uses ShippingDeliveryResultVO::setSenderCustId()
     * @uses ShippingDeliveryResultVO::setShippingDeliveryDetailVO()
     * @param int $count
     * @param int $senderCustId
     * @param \StructType\ShippingDeliveryDetailVO[] $shippingDeliveryDetailVO
     */
    public function __construct($count = null, $senderCustId = null, array $shippingDeliveryDetailVO = array())
    {
        $this
            ->setCount($count)
            ->setSenderCustId($senderCustId)
            ->setShippingDeliveryDetailVO($shippingDeliveryDetailVO);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\ShippingDeliveryResultVO
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get senderCustId value
     * @return int|null
     */
    public function getSenderCustId()
    {
        return $this->senderCustId;
    }
    /**
     * Set senderCustId value
     * @param int $senderCustId
     * @return \StructType\ShippingDeliveryResultVO
     */
    public function setSenderCustId($senderCustId = null)
    {
        // validation for constraint: int
        if (!is_null($senderCustId) && !(is_int($senderCustId) || ctype_digit($senderCustId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senderCustId, true), gettype($senderCustId)), __LINE__);
        }
        $this->senderCustId = $senderCustId;
        return $this;
    }
    /**
     * Get shippingDeliveryDetailVO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShippingDeliveryDetailVO[]|null
     */
    public function getShippingDeliveryDetailVO()
    {
        return isset($this->shippingDeliveryDetailVO) ? $this->shippingDeliveryDetailVO : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingDeliveryDetailVO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingDeliveryDetailVO method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingDeliveryDetailVOForArrayConstraintsFromSetShippingDeliveryDetailVO(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingDeliveryResultVOShippingDeliveryDetailVOItem) {
            // validation for constraint: itemType
            if (!$shippingDeliveryResultVOShippingDeliveryDetailVOItem instanceof \StructType\ShippingDeliveryDetailVO) {
                $invalidValues[] = is_object($shippingDeliveryResultVOShippingDeliveryDetailVOItem) ? get_class($shippingDeliveryResultVOShippingDeliveryDetailVOItem) : sprintf('%s(%s)', gettype($shippingDeliveryResultVOShippingDeliveryDetailVOItem), var_export($shippingDeliveryResultVOShippingDeliveryDetailVOItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shippingDeliveryDetailVO property can only contain items of type \StructType\ShippingDeliveryDetailVO, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shippingDeliveryDetailVO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingDeliveryDetailVO[] $shippingDeliveryDetailVO
     * @return \StructType\ShippingDeliveryResultVO
     */
    public function setShippingDeliveryDetailVO(array $shippingDeliveryDetailVO = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingDeliveryDetailVOArrayErrorMessage = self::validateShippingDeliveryDetailVOForArrayConstraintsFromSetShippingDeliveryDetailVO($shippingDeliveryDetailVO))) {
            throw new \InvalidArgumentException($shippingDeliveryDetailVOArrayErrorMessage, __LINE__);
        }
        if (is_null($shippingDeliveryDetailVO) || (is_array($shippingDeliveryDetailVO) && empty($shippingDeliveryDetailVO))) {
            unset($this->shippingDeliveryDetailVO);
        } else {
            $this->shippingDeliveryDetailVO = $shippingDeliveryDetailVO;
        }
        return $this;
    }
    /**
     * Add item to shippingDeliveryDetailVO value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingDeliveryDetailVO $item
     * @return \StructType\ShippingDeliveryResultVO
     */
    public function addToShippingDeliveryDetailVO(\StructType\ShippingDeliveryDetailVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShippingDeliveryDetailVO) {
            throw new \InvalidArgumentException(sprintf('The shippingDeliveryDetailVO property can only contain items of type \StructType\ShippingDeliveryDetailVO, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shippingDeliveryDetailVO[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingDeliveryResultVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
