<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for queryShipmentDetail StructType
 * Meta information extracted from the WSDL
 * - type: tns:queryShipmentDetail
 * @subpackage Structs
 */
class QueryShipmentDetail extends AbstractStructBase
{
    /**
     * The wsUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wsUserName;
    /**
     * The wsPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wsPassword;
    /**
     * The wsLanguage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wsLanguage;
    /**
     * The keys
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $keys;
    /**
     * The keyType
     * @var int
     */
    public $keyType;
    /**
     * The addHistoricalData
     * @var bool
     */
    public $addHistoricalData;
    /**
     * The onlyTracking
     * @var bool
     */
    public $onlyTracking;
    /**
     * The jsonData
     * @var bool
     */
    public $jsonData;
    /**
     * Constructor method for queryShipmentDetail
     * @uses QueryShipmentDetail::setWsUserName()
     * @uses QueryShipmentDetail::setWsPassword()
     * @uses QueryShipmentDetail::setWsLanguage()
     * @uses QueryShipmentDetail::setKeys()
     * @uses QueryShipmentDetail::setKeyType()
     * @uses QueryShipmentDetail::setAddHistoricalData()
     * @uses QueryShipmentDetail::setOnlyTracking()
     * @uses QueryShipmentDetail::setJsonData()
     * @param string $wsUserName
     * @param string $wsPassword
     * @param string $wsLanguage
     * @param string[] $keys
     * @param int $keyType
     * @param bool $addHistoricalData
     * @param bool $onlyTracking
     * @param bool $jsonData
     */
    public function __construct($wsUserName = null, $wsPassword = null, $wsLanguage = null, array $keys = array(), $keyType = null, $addHistoricalData = null, $onlyTracking = null, $jsonData = null)
    {
        $this
            ->setWsUserName($wsUserName)
            ->setWsPassword($wsPassword)
            ->setWsLanguage($wsLanguage)
            ->setKeys($keys)
            ->setKeyType($keyType)
            ->setAddHistoricalData($addHistoricalData)
            ->setOnlyTracking($onlyTracking)
            ->setJsonData($jsonData);
    }
    /**
     * Get wsUserName value
     * @return string|null
     */
    public function getWsUserName()
    {
        return $this->wsUserName;
    }
    /**
     * Set wsUserName value
     * @param string $wsUserName
     * @return \StructType\QueryShipmentDetail
     */
    public function setWsUserName($wsUserName = null)
    {
        // validation for constraint: string
        if (!is_null($wsUserName) && !is_string($wsUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsUserName, true), gettype($wsUserName)), __LINE__);
        }
        $this->wsUserName = $wsUserName;
        return $this;
    }
    /**
     * Get wsPassword value
     * @return string|null
     */
    public function getWsPassword()
    {
        return $this->wsPassword;
    }
    /**
     * Set wsPassword value
     * @param string $wsPassword
     * @return \StructType\QueryShipmentDetail
     */
    public function setWsPassword($wsPassword = null)
    {
        // validation for constraint: string
        if (!is_null($wsPassword) && !is_string($wsPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsPassword, true), gettype($wsPassword)), __LINE__);
        }
        $this->wsPassword = $wsPassword;
        return $this;
    }
    /**
     * Get wsLanguage value
     * @return string|null
     */
    public function getWsLanguage()
    {
        return $this->wsLanguage;
    }
    /**
     * Set wsLanguage value
     * @param string $wsLanguage
     * @return \StructType\QueryShipmentDetail
     */
    public function setWsLanguage($wsLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($wsLanguage) && !is_string($wsLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsLanguage, true), gettype($wsLanguage)), __LINE__);
        }
        $this->wsLanguage = $wsLanguage;
        return $this;
    }
    /**
     * Get keys value
     * @return string[]|null
     */
    public function getKeys()
    {
        return $this->keys;
    }
    /**
     * This method is responsible for validating the values passed to the setKeys method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeys method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeysForArrayConstraintsFromSetKeys(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $queryShipmentDetailKeysItem) {
            // validation for constraint: itemType
            if (!is_string($queryShipmentDetailKeysItem)) {
                $invalidValues[] = is_object($queryShipmentDetailKeysItem) ? get_class($queryShipmentDetailKeysItem) : sprintf('%s(%s)', gettype($queryShipmentDetailKeysItem), var_export($queryShipmentDetailKeysItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The keys property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set keys value
     * @throws \InvalidArgumentException
     * @param string[] $keys
     * @return \StructType\QueryShipmentDetail
     */
    public function setKeys(array $keys = array())
    {
        // validation for constraint: array
        if ('' !== ($keysArrayErrorMessage = self::validateKeysForArrayConstraintsFromSetKeys($keys))) {
            throw new \InvalidArgumentException($keysArrayErrorMessage, __LINE__);
        }
        $this->keys = $keys;
        return $this;
    }
    /**
     * Add item to keys value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\QueryShipmentDetail
     */
    public function addToKeys($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The keys property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->keys[] = $item;
        return $this;
    }
    /**
     * Get keyType value
     * @return int|null
     */
    public function getKeyType()
    {
        return $this->keyType;
    }
    /**
     * Set keyType value
     * @param int $keyType
     * @return \StructType\QueryShipmentDetail
     */
    public function setKeyType($keyType = null)
    {
        // validation for constraint: int
        if (!is_null($keyType) && !(is_int($keyType) || ctype_digit($keyType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keyType, true), gettype($keyType)), __LINE__);
        }
        $this->keyType = $keyType;
        return $this;
    }
    /**
     * Get addHistoricalData value
     * @return bool|null
     */
    public function getAddHistoricalData()
    {
        return $this->addHistoricalData;
    }
    /**
     * Set addHistoricalData value
     * @param bool $addHistoricalData
     * @return \StructType\QueryShipmentDetail
     */
    public function setAddHistoricalData($addHistoricalData = null)
    {
        // validation for constraint: boolean
        if (!is_null($addHistoricalData) && !is_bool($addHistoricalData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addHistoricalData, true), gettype($addHistoricalData)), __LINE__);
        }
        $this->addHistoricalData = $addHistoricalData;
        return $this;
    }
    /**
     * Get onlyTracking value
     * @return bool|null
     */
    public function getOnlyTracking()
    {
        return $this->onlyTracking;
    }
    /**
     * Set onlyTracking value
     * @param bool $onlyTracking
     * @return \StructType\QueryShipmentDetail
     */
    public function setOnlyTracking($onlyTracking = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyTracking) && !is_bool($onlyTracking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyTracking, true), gettype($onlyTracking)), __LINE__);
        }
        $this->onlyTracking = $onlyTracking;
        return $this;
    }
    /**
     * Get jsonData value
     * @return bool|null
     */
    public function getJsonData()
    {
        return $this->jsonData;
    }
    /**
     * Set jsonData value
     * @param bool $jsonData
     * @return \StructType\QueryShipmentDetail
     */
    public function setJsonData($jsonData = null)
    {
        // validation for constraint: boolean
        if (!is_null($jsonData) && !is_bool($jsonData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($jsonData, true), gettype($jsonData)), __LINE__);
        }
        $this->jsonData = $jsonData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QueryShipmentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
