<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvDocFieldVO StructType
 * @subpackage Structs
 */
class InvDocFieldVO extends AbstractStructBase
{
    /**
     * The docId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docId;
    /**
     * The fieldName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fieldName;
    /**
     * The fieldNameExplanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fieldNameExplanation;
    /**
     * The fieldValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fieldValue;
    /**
     * Constructor method for InvDocFieldVO
     * @uses InvDocFieldVO::setDocId()
     * @uses InvDocFieldVO::setFieldName()
     * @uses InvDocFieldVO::setFieldNameExplanation()
     * @uses InvDocFieldVO::setFieldValue()
     * @param string $docId
     * @param string $fieldName
     * @param string $fieldNameExplanation
     * @param string $fieldValue
     */
    public function __construct($docId = null, $fieldName = null, $fieldNameExplanation = null, $fieldValue = null)
    {
        $this
            ->setDocId($docId)
            ->setFieldName($fieldName)
            ->setFieldNameExplanation($fieldNameExplanation)
            ->setFieldValue($fieldValue);
    }
    /**
     * Get docId value
     * @return string|null
     */
    public function getDocId()
    {
        return $this->docId;
    }
    /**
     * Set docId value
     * @param string $docId
     * @return \StructType\InvDocFieldVO
     */
    public function setDocId($docId = null)
    {
        // validation for constraint: string
        if (!is_null($docId) && !is_string($docId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docId, true), gettype($docId)), __LINE__);
        }
        $this->docId = $docId;
        return $this;
    }
    /**
     * Get fieldName value
     * @return string|null
     */
    public function getFieldName()
    {
        return $this->fieldName;
    }
    /**
     * Set fieldName value
     * @param string $fieldName
     * @return \StructType\InvDocFieldVO
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldName, true), gettype($fieldName)), __LINE__);
        }
        $this->fieldName = $fieldName;
        return $this;
    }
    /**
     * Get fieldNameExplanation value
     * @return string|null
     */
    public function getFieldNameExplanation()
    {
        return $this->fieldNameExplanation;
    }
    /**
     * Set fieldNameExplanation value
     * @param string $fieldNameExplanation
     * @return \StructType\InvDocFieldVO
     */
    public function setFieldNameExplanation($fieldNameExplanation = null)
    {
        // validation for constraint: string
        if (!is_null($fieldNameExplanation) && !is_string($fieldNameExplanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldNameExplanation, true), gettype($fieldNameExplanation)), __LINE__);
        }
        $this->fieldNameExplanation = $fieldNameExplanation;
        return $this;
    }
    /**
     * Get fieldValue value
     * @return string|null
     */
    public function getFieldValue()
    {
        return $this->fieldValue;
    }
    /**
     * Set fieldValue value
     * @param string $fieldValue
     * @return \StructType\InvDocFieldVO
     */
    public function setFieldValue($fieldValue = null)
    {
        // validation for constraint: string
        if (!is_null($fieldValue) && !is_string($fieldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldValue, true), gettype($fieldValue)), __LINE__);
        }
        $this->fieldValue = $fieldValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvDocFieldVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
