<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingCancelDetailVO StructType
 * @subpackage Structs
 */
class ShippingCancelDetailVO extends AbstractStructBase
{
    /**
     * The cargoKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoKey;
    /**
     * The docId
     * @var int
     */
    public $docId;
    /**
     * The errCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $errCode;
    /**
     * The errMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errMessage;
    /**
     * The invoiceKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoiceKey;
    /**
     * The jobId
     * @var int
     */
    public $jobId;
    /**
     * The operationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationCode;
    /**
     * The operationMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operationMessage;
    /**
     * The operationStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operationStatus;
    /**
     * Constructor method for shippingCancelDetailVO
     * @uses ShippingCancelDetailVO::setCargoKey()
     * @uses ShippingCancelDetailVO::setDocId()
     * @uses ShippingCancelDetailVO::setErrCode()
     * @uses ShippingCancelDetailVO::setErrMessage()
     * @uses ShippingCancelDetailVO::setInvoiceKey()
     * @uses ShippingCancelDetailVO::setJobId()
     * @uses ShippingCancelDetailVO::setOperationCode()
     * @uses ShippingCancelDetailVO::setOperationMessage()
     * @uses ShippingCancelDetailVO::setOperationStatus()
     * @param string $cargoKey
     * @param int $docId
     * @param int $errCode
     * @param string $errMessage
     * @param string $invoiceKey
     * @param int $jobId
     * @param int $operationCode
     * @param string $operationMessage
     * @param string $operationStatus
     */
    public function __construct($cargoKey = null, $docId = null, $errCode = null, $errMessage = null, $invoiceKey = null, $jobId = null, $operationCode = null, $operationMessage = null, $operationStatus = null)
    {
        $this
            ->setCargoKey($cargoKey)
            ->setDocId($docId)
            ->setErrCode($errCode)
            ->setErrMessage($errMessage)
            ->setInvoiceKey($invoiceKey)
            ->setJobId($jobId)
            ->setOperationCode($operationCode)
            ->setOperationMessage($operationMessage)
            ->setOperationStatus($operationStatus);
    }
    /**
     * Get cargoKey value
     * @return string|null
     */
    public function getCargoKey()
    {
        return $this->cargoKey;
    }
    /**
     * Set cargoKey value
     * @param string $cargoKey
     * @return \StructType\ShippingCancelDetailVO
     */
    public function setCargoKey($cargoKey = null)
    {
        // validation for constraint: string
        if (!is_null($cargoKey) && !is_string($cargoKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoKey, true), gettype($cargoKey)), __LINE__);
        }
        $this->cargoKey = $cargoKey;
        return $this;
    }
    /**
     * Get docId value
     * @return int|null
     */
    public function getDocId()
    {
        return $this->docId;
    }
    /**
     * Set docId value
     * @param int $docId
     * @return \StructType\ShippingCancelDetailVO
     */
    public function setDocId($docId = null)
    {
        // validation for constraint: int
        if (!is_null($docId) && !(is_int($docId) || ctype_digit($docId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($docId, true), gettype($docId)), __LINE__);
        }
        $this->docId = $docId;
        return $this;
    }
    /**
     * Get errCode value
     * @return int|null
     */
    public function getErrCode()
    {
        return $this->errCode;
    }
    /**
     * Set errCode value
     * @param int $errCode
     * @return \StructType\ShippingCancelDetailVO
     */
    public function setErrCode($errCode = null)
    {
        // validation for constraint: int
        if (!is_null($errCode) && !(is_int($errCode) || ctype_digit($errCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errCode, true), gettype($errCode)), __LINE__);
        }
        $this->errCode = $errCode;
        return $this;
    }
    /**
     * Get errMessage value
     * @return string|null
     */
    public function getErrMessage()
    {
        return $this->errMessage;
    }
    /**
     * Set errMessage value
     * @param string $errMessage
     * @return \StructType\ShippingCancelDetailVO
     */
    public function setErrMessage($errMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errMessage) && !is_string($errMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errMessage, true), gettype($errMessage)), __LINE__);
        }
        $this->errMessage = $errMessage;
        return $this;
    }
    /**
     * Get invoiceKey value
     * @return string|null
     */
    public function getInvoiceKey()
    {
        return $this->invoiceKey;
    }
    /**
     * Set invoiceKey value
     * @param string $invoiceKey
     * @return \StructType\ShippingCancelDetailVO
     */
    public function setInvoiceKey($invoiceKey = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceKey) && !is_string($invoiceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceKey, true), gettype($invoiceKey)), __LINE__);
        }
        $this->invoiceKey = $invoiceKey;
        return $this;
    }
    /**
     * Get jobId value
     * @return int|null
     */
    public function getJobId()
    {
        return $this->jobId;
    }
    /**
     * Set jobId value
     * @param int $jobId
     * @return \StructType\ShippingCancelDetailVO
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: int
        if (!is_null($jobId) && !(is_int($jobId) || ctype_digit($jobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->jobId = $jobId;
        return $this;
    }
    /**
     * Get operationCode value
     * @return int|null
     */
    public function getOperationCode()
    {
        return $this->operationCode;
    }
    /**
     * Set operationCode value
     * @param int $operationCode
     * @return \StructType\ShippingCancelDetailVO
     */
    public function setOperationCode($operationCode = null)
    {
        // validation for constraint: int
        if (!is_null($operationCode) && !(is_int($operationCode) || ctype_digit($operationCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationCode, true), gettype($operationCode)), __LINE__);
        }
        $this->operationCode = $operationCode;
        return $this;
    }
    /**
     * Get operationMessage value
     * @return string|null
     */
    public function getOperationMessage()
    {
        return $this->operationMessage;
    }
    /**
     * Set operationMessage value
     * @param string $operationMessage
     * @return \StructType\ShippingCancelDetailVO
     */
    public function setOperationMessage($operationMessage = null)
    {
        // validation for constraint: string
        if (!is_null($operationMessage) && !is_string($operationMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationMessage, true), gettype($operationMessage)), __LINE__);
        }
        $this->operationMessage = $operationMessage;
        return $this;
    }
    /**
     * Get operationStatus value
     * @return string|null
     */
    public function getOperationStatus()
    {
        return $this->operationStatus;
    }
    /**
     * Set operationStatus value
     * @param string $operationStatus
     * @return \StructType\ShippingCancelDetailVO
     */
    public function setOperationStatus($operationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($operationStatus) && !is_string($operationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationStatus, true), gettype($operationStatus)), __LINE__);
        }
        $this->operationStatus = $operationStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingCancelDetailVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
