<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentDeliveryItemDetailVO StructType
 * Meta information extracted from the WSDL
 * - type: tns:ShipmentDeliveryItemDetailVO
 * @subpackage Structs
 */
class ShipmentDeliveryItemDetailVO extends ShippingDeliveryItemDetailVO
{
    /**
     * The estimatedDeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $estimatedDeliveryDate;
    /**
     * The estimatedDeliveryTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $estimatedDeliveryTime;
    /**
     * The perfCFlag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $perfCFlag;
    /**
     * The delivDurationWorkDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $delivDurationWorkDay;
    /**
     * The delivDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $delivDuration;
    /**
     * The perfLateCEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $perfLateCEvent;
    /**
     * The perfLateCReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $perfLateCReason;
    /**
     * The receiverPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $receiverPhone;
    /**
     * The receiverGsm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $receiverGsm;
    /**
     * The shipmentDistance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipmentDistance;
    /**
     * Constructor method for ShipmentDeliveryItemDetailVO
     * @uses ShipmentDeliveryItemDetailVO::setEstimatedDeliveryDate()
     * @uses ShipmentDeliveryItemDetailVO::setEstimatedDeliveryTime()
     * @uses ShipmentDeliveryItemDetailVO::setPerfCFlag()
     * @uses ShipmentDeliveryItemDetailVO::setDelivDurationWorkDay()
     * @uses ShipmentDeliveryItemDetailVO::setDelivDuration()
     * @uses ShipmentDeliveryItemDetailVO::setPerfLateCEvent()
     * @uses ShipmentDeliveryItemDetailVO::setPerfLateCReason()
     * @uses ShipmentDeliveryItemDetailVO::setReceiverPhone()
     * @uses ShipmentDeliveryItemDetailVO::setReceiverGsm()
     * @uses ShipmentDeliveryItemDetailVO::setShipmentDistance()
     * @param string $estimatedDeliveryDate
     * @param string $estimatedDeliveryTime
     * @param string $perfCFlag
     * @param string $delivDurationWorkDay
     * @param string $delivDuration
     * @param string $perfLateCEvent
     * @param string $perfLateCReason
     * @param string $receiverPhone
     * @param string $receiverGsm
     * @param string $shipmentDistance
     */
    public function __construct($estimatedDeliveryDate = null, $estimatedDeliveryTime = null, $perfCFlag = null, $delivDurationWorkDay = null, $delivDuration = null, $perfLateCEvent = null, $perfLateCReason = null, $receiverPhone = null, $receiverGsm = null, $shipmentDistance = null)
    {
        $this
            ->setEstimatedDeliveryDate($estimatedDeliveryDate)
            ->setEstimatedDeliveryTime($estimatedDeliveryTime)
            ->setPerfCFlag($perfCFlag)
            ->setDelivDurationWorkDay($delivDurationWorkDay)
            ->setDelivDuration($delivDuration)
            ->setPerfLateCEvent($perfLateCEvent)
            ->setPerfLateCReason($perfLateCReason)
            ->setReceiverPhone($receiverPhone)
            ->setReceiverGsm($receiverGsm)
            ->setShipmentDistance($shipmentDistance);
    }
    /**
     * Get estimatedDeliveryDate value
     * @return string|null
     */
    public function getEstimatedDeliveryDate()
    {
        return $this->estimatedDeliveryDate;
    }
    /**
     * Set estimatedDeliveryDate value
     * @param string $estimatedDeliveryDate
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public function setEstimatedDeliveryDate($estimatedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeliveryDate) && !is_string($estimatedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeliveryDate, true), gettype($estimatedDeliveryDate)), __LINE__);
        }
        $this->estimatedDeliveryDate = $estimatedDeliveryDate;
        return $this;
    }
    /**
     * Get estimatedDeliveryTime value
     * @return string|null
     */
    public function getEstimatedDeliveryTime()
    {
        return $this->estimatedDeliveryTime;
    }
    /**
     * Set estimatedDeliveryTime value
     * @param string $estimatedDeliveryTime
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public function setEstimatedDeliveryTime($estimatedDeliveryTime = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeliveryTime) && !is_string($estimatedDeliveryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeliveryTime, true), gettype($estimatedDeliveryTime)), __LINE__);
        }
        $this->estimatedDeliveryTime = $estimatedDeliveryTime;
        return $this;
    }
    /**
     * Get perfCFlag value
     * @return string|null
     */
    public function getPerfCFlag()
    {
        return $this->perfCFlag;
    }
    /**
     * Set perfCFlag value
     * @param string $perfCFlag
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public function setPerfCFlag($perfCFlag = null)
    {
        // validation for constraint: string
        if (!is_null($perfCFlag) && !is_string($perfCFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($perfCFlag, true), gettype($perfCFlag)), __LINE__);
        }
        $this->perfCFlag = $perfCFlag;
        return $this;
    }
    /**
     * Get delivDurationWorkDay value
     * @return string|null
     */
    public function getDelivDurationWorkDay()
    {
        return $this->delivDurationWorkDay;
    }
    /**
     * Set delivDurationWorkDay value
     * @param string $delivDurationWorkDay
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public function setDelivDurationWorkDay($delivDurationWorkDay = null)
    {
        // validation for constraint: string
        if (!is_null($delivDurationWorkDay) && !is_string($delivDurationWorkDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delivDurationWorkDay, true), gettype($delivDurationWorkDay)), __LINE__);
        }
        $this->delivDurationWorkDay = $delivDurationWorkDay;
        return $this;
    }
    /**
     * Get delivDuration value
     * @return string|null
     */
    public function getDelivDuration()
    {
        return $this->delivDuration;
    }
    /**
     * Set delivDuration value
     * @param string $delivDuration
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public function setDelivDuration($delivDuration = null)
    {
        // validation for constraint: string
        if (!is_null($delivDuration) && !is_string($delivDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delivDuration, true), gettype($delivDuration)), __LINE__);
        }
        $this->delivDuration = $delivDuration;
        return $this;
    }
    /**
     * Get perfLateCEvent value
     * @return string|null
     */
    public function getPerfLateCEvent()
    {
        return $this->perfLateCEvent;
    }
    /**
     * Set perfLateCEvent value
     * @param string $perfLateCEvent
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public function setPerfLateCEvent($perfLateCEvent = null)
    {
        // validation for constraint: string
        if (!is_null($perfLateCEvent) && !is_string($perfLateCEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($perfLateCEvent, true), gettype($perfLateCEvent)), __LINE__);
        }
        $this->perfLateCEvent = $perfLateCEvent;
        return $this;
    }
    /**
     * Get perfLateCReason value
     * @return string|null
     */
    public function getPerfLateCReason()
    {
        return $this->perfLateCReason;
    }
    /**
     * Set perfLateCReason value
     * @param string $perfLateCReason
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public function setPerfLateCReason($perfLateCReason = null)
    {
        // validation for constraint: string
        if (!is_null($perfLateCReason) && !is_string($perfLateCReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($perfLateCReason, true), gettype($perfLateCReason)), __LINE__);
        }
        $this->perfLateCReason = $perfLateCReason;
        return $this;
    }
    /**
     * Get receiverPhone value
     * @return string|null
     */
    public function getReceiverPhone()
    {
        return $this->receiverPhone;
    }
    /**
     * Set receiverPhone value
     * @param string $receiverPhone
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public function setReceiverPhone($receiverPhone = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhone) && !is_string($receiverPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverPhone, true), gettype($receiverPhone)), __LINE__);
        }
        $this->receiverPhone = $receiverPhone;
        return $this;
    }
    /**
     * Get receiverGsm value
     * @return string|null
     */
    public function getReceiverGsm()
    {
        return $this->receiverGsm;
    }
    /**
     * Set receiverGsm value
     * @param string $receiverGsm
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public function setReceiverGsm($receiverGsm = null)
    {
        // validation for constraint: string
        if (!is_null($receiverGsm) && !is_string($receiverGsm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverGsm, true), gettype($receiverGsm)), __LINE__);
        }
        $this->receiverGsm = $receiverGsm;
        return $this;
    }
    /**
     * Get shipmentDistance value
     * @return string|null
     */
    public function getShipmentDistance()
    {
        return $this->shipmentDistance;
    }
    /**
     * Set shipmentDistance value
     * @param string $shipmentDistance
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public function setShipmentDistance($shipmentDistance = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDistance) && !is_string($shipmentDistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDistance, true), gettype($shipmentDistance)), __LINE__);
        }
        $this->shipmentDistance = $shipmentDistance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentDeliveryItemDetailVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
