<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createShipment StructType
 * Meta information extracted from the WSDL
 * - type: tns:createShipment
 * @subpackage Structs
 */
class CreateShipment extends AbstractStructBase
{
    /**
     * The wsUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wsUserName;
    /**
     * The wsPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wsPassword;
    /**
     * The userLanguage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userLanguage;
    /**
     * The ShippingOrderVO
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShippingOrderVO[]
     */
    public $ShippingOrderVO;
    /**
     * Constructor method for createShipment
     * @uses CreateShipment::setWsUserName()
     * @uses CreateShipment::setWsPassword()
     * @uses CreateShipment::setUserLanguage()
     * @uses CreateShipment::setShippingOrderVO()
     * @param string $wsUserName
     * @param string $wsPassword
     * @param string $userLanguage
     * @param \StructType\ShippingOrderVO[] $shippingOrderVO
     */
    public function __construct($wsUserName = null, $wsPassword = null, $userLanguage = null, array $shippingOrderVO = array())
    {
        $this
            ->setWsUserName($wsUserName)
            ->setWsPassword($wsPassword)
            ->setUserLanguage($userLanguage)
            ->setShippingOrderVO($shippingOrderVO);
    }
    /**
     * Get wsUserName value
     * @return string|null
     */
    public function getWsUserName()
    {
        return $this->wsUserName;
    }
    /**
     * Set wsUserName value
     * @param string $wsUserName
     * @return \StructType\CreateShipment
     */
    public function setWsUserName($wsUserName = null)
    {
        // validation for constraint: string
        if (!is_null($wsUserName) && !is_string($wsUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsUserName, true), gettype($wsUserName)), __LINE__);
        }
        $this->wsUserName = $wsUserName;
        return $this;
    }
    /**
     * Get wsPassword value
     * @return string|null
     */
    public function getWsPassword()
    {
        return $this->wsPassword;
    }
    /**
     * Set wsPassword value
     * @param string $wsPassword
     * @return \StructType\CreateShipment
     */
    public function setWsPassword($wsPassword = null)
    {
        // validation for constraint: string
        if (!is_null($wsPassword) && !is_string($wsPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsPassword, true), gettype($wsPassword)), __LINE__);
        }
        $this->wsPassword = $wsPassword;
        return $this;
    }
    /**
     * Get userLanguage value
     * @return string|null
     */
    public function getUserLanguage()
    {
        return $this->userLanguage;
    }
    /**
     * Set userLanguage value
     * @param string $userLanguage
     * @return \StructType\CreateShipment
     */
    public function setUserLanguage($userLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($userLanguage) && !is_string($userLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLanguage, true), gettype($userLanguage)), __LINE__);
        }
        $this->userLanguage = $userLanguage;
        return $this;
    }
    /**
     * Get ShippingOrderVO value
     * @return \StructType\ShippingOrderVO[]|null
     */
    public function getShippingOrderVO()
    {
        return $this->ShippingOrderVO;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingOrderVO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingOrderVO method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingOrderVOForArrayConstraintsFromSetShippingOrderVO(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createShipmentShippingOrderVOItem) {
            // validation for constraint: itemType
            if (!$createShipmentShippingOrderVOItem instanceof \StructType\ShippingOrderVO) {
                $invalidValues[] = is_object($createShipmentShippingOrderVOItem) ? get_class($createShipmentShippingOrderVOItem) : sprintf('%s(%s)', gettype($createShipmentShippingOrderVOItem), var_export($createShipmentShippingOrderVOItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShippingOrderVO property can only contain items of type \StructType\ShippingOrderVO, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShippingOrderVO value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingOrderVO[] $shippingOrderVO
     * @return \StructType\CreateShipment
     */
    public function setShippingOrderVO(array $shippingOrderVO = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingOrderVOArrayErrorMessage = self::validateShippingOrderVOForArrayConstraintsFromSetShippingOrderVO($shippingOrderVO))) {
            throw new \InvalidArgumentException($shippingOrderVOArrayErrorMessage, __LINE__);
        }
        $this->ShippingOrderVO = $shippingOrderVO;
        return $this;
    }
    /**
     * Add item to ShippingOrderVO value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingOrderVO $item
     * @return \StructType\CreateShipment
     */
    public function addToShippingOrderVO(\StructType\ShippingOrderVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShippingOrderVO) {
            throw new \InvalidArgumentException(sprintf('The ShippingOrderVO property can only contain items of type \StructType\ShippingOrderVO, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShippingOrderVO[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
