<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingCancelResultVO StructType
 * @subpackage Structs
 */
class ShippingCancelResultVO extends ExtendedBaseResultVO
{
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * The senderCustId
     * @var int
     */
    public $senderCustId;
    /**
     * The shippingCancelDetailVO
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShippingCancelDetailVO[]
     */
    public $shippingCancelDetailVO;
    /**
     * Constructor method for shippingCancelResultVO
     * @uses ShippingCancelResultVO::setCount()
     * @uses ShippingCancelResultVO::setSenderCustId()
     * @uses ShippingCancelResultVO::setShippingCancelDetailVO()
     * @param int $count
     * @param int $senderCustId
     * @param \StructType\ShippingCancelDetailVO[] $shippingCancelDetailVO
     */
    public function __construct($count = null, $senderCustId = null, array $shippingCancelDetailVO = array())
    {
        $this
            ->setCount($count)
            ->setSenderCustId($senderCustId)
            ->setShippingCancelDetailVO($shippingCancelDetailVO);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\ShippingCancelResultVO
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get senderCustId value
     * @return int|null
     */
    public function getSenderCustId()
    {
        return $this->senderCustId;
    }
    /**
     * Set senderCustId value
     * @param int $senderCustId
     * @return \StructType\ShippingCancelResultVO
     */
    public function setSenderCustId($senderCustId = null)
    {
        // validation for constraint: int
        if (!is_null($senderCustId) && !(is_int($senderCustId) || ctype_digit($senderCustId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senderCustId, true), gettype($senderCustId)), __LINE__);
        }
        $this->senderCustId = $senderCustId;
        return $this;
    }
    /**
     * Get shippingCancelDetailVO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShippingCancelDetailVO[]|null
     */
    public function getShippingCancelDetailVO()
    {
        return isset($this->shippingCancelDetailVO) ? $this->shippingCancelDetailVO : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingCancelDetailVO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingCancelDetailVO method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingCancelDetailVOForArrayConstraintsFromSetShippingCancelDetailVO(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingCancelResultVOShippingCancelDetailVOItem) {
            // validation for constraint: itemType
            if (!$shippingCancelResultVOShippingCancelDetailVOItem instanceof \StructType\ShippingCancelDetailVO) {
                $invalidValues[] = is_object($shippingCancelResultVOShippingCancelDetailVOItem) ? get_class($shippingCancelResultVOShippingCancelDetailVOItem) : sprintf('%s(%s)', gettype($shippingCancelResultVOShippingCancelDetailVOItem), var_export($shippingCancelResultVOShippingCancelDetailVOItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shippingCancelDetailVO property can only contain items of type \StructType\ShippingCancelDetailVO, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shippingCancelDetailVO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingCancelDetailVO[] $shippingCancelDetailVO
     * @return \StructType\ShippingCancelResultVO
     */
    public function setShippingCancelDetailVO(array $shippingCancelDetailVO = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingCancelDetailVOArrayErrorMessage = self::validateShippingCancelDetailVOForArrayConstraintsFromSetShippingCancelDetailVO($shippingCancelDetailVO))) {
            throw new \InvalidArgumentException($shippingCancelDetailVOArrayErrorMessage, __LINE__);
        }
        if (is_null($shippingCancelDetailVO) || (is_array($shippingCancelDetailVO) && empty($shippingCancelDetailVO))) {
            unset($this->shippingCancelDetailVO);
        } else {
            $this->shippingCancelDetailVO = $shippingCancelDetailVO;
        }
        return $this;
    }
    /**
     * Add item to shippingCancelDetailVO value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingCancelDetailVO $item
     * @return \StructType\ShippingCancelResultVO
     */
    public function addToShippingCancelDetailVO(\StructType\ShippingCancelDetailVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShippingCancelDetailVO) {
            throw new \InvalidArgumentException(sprintf('The shippingCancelDetailVO property can only contain items of type \StructType\ShippingCancelDetailVO, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shippingCancelDetailVO[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingCancelResultVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
