<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shipmentDeliveryResultVO StructType
 * @subpackage Structs
 */
class ShipmentDeliveryResultVO extends ExtendedBaseResultVO
{
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * The deliveryResultData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryResultData;
    /**
     * The senderCustId
     * @var int
     */
    public $senderCustId;
    /**
     * The shipmentDeliveryDetailVO
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShipmentDeliveryDetailVO[]
     */
    public $shipmentDeliveryDetailVO;
    /**
     * Constructor method for shipmentDeliveryResultVO
     * @uses ShipmentDeliveryResultVO::setCount()
     * @uses ShipmentDeliveryResultVO::setDeliveryResultData()
     * @uses ShipmentDeliveryResultVO::setSenderCustId()
     * @uses ShipmentDeliveryResultVO::setShipmentDeliveryDetailVO()
     * @param int $count
     * @param string $deliveryResultData
     * @param int $senderCustId
     * @param \StructType\ShipmentDeliveryDetailVO[] $shipmentDeliveryDetailVO
     */
    public function __construct($count = null, $deliveryResultData = null, $senderCustId = null, array $shipmentDeliveryDetailVO = array())
    {
        $this
            ->setCount($count)
            ->setDeliveryResultData($deliveryResultData)
            ->setSenderCustId($senderCustId)
            ->setShipmentDeliveryDetailVO($shipmentDeliveryDetailVO);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\ShipmentDeliveryResultVO
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get deliveryResultData value
     * @return string|null
     */
    public function getDeliveryResultData()
    {
        return $this->deliveryResultData;
    }
    /**
     * Set deliveryResultData value
     * @param string $deliveryResultData
     * @return \StructType\ShipmentDeliveryResultVO
     */
    public function setDeliveryResultData($deliveryResultData = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryResultData) && !is_string($deliveryResultData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryResultData, true), gettype($deliveryResultData)), __LINE__);
        }
        $this->deliveryResultData = $deliveryResultData;
        return $this;
    }
    /**
     * Get senderCustId value
     * @return int|null
     */
    public function getSenderCustId()
    {
        return $this->senderCustId;
    }
    /**
     * Set senderCustId value
     * @param int $senderCustId
     * @return \StructType\ShipmentDeliveryResultVO
     */
    public function setSenderCustId($senderCustId = null)
    {
        // validation for constraint: int
        if (!is_null($senderCustId) && !(is_int($senderCustId) || ctype_digit($senderCustId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senderCustId, true), gettype($senderCustId)), __LINE__);
        }
        $this->senderCustId = $senderCustId;
        return $this;
    }
    /**
     * Get shipmentDeliveryDetailVO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShipmentDeliveryDetailVO[]|null
     */
    public function getShipmentDeliveryDetailVO()
    {
        return isset($this->shipmentDeliveryDetailVO) ? $this->shipmentDeliveryDetailVO : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentDeliveryDetailVO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentDeliveryDetailVO method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentDeliveryDetailVOForArrayConstraintsFromSetShipmentDeliveryDetailVO(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentDeliveryResultVOShipmentDeliveryDetailVOItem) {
            // validation for constraint: itemType
            if (!$shipmentDeliveryResultVOShipmentDeliveryDetailVOItem instanceof \StructType\ShipmentDeliveryDetailVO) {
                $invalidValues[] = is_object($shipmentDeliveryResultVOShipmentDeliveryDetailVOItem) ? get_class($shipmentDeliveryResultVOShipmentDeliveryDetailVOItem) : sprintf('%s(%s)', gettype($shipmentDeliveryResultVOShipmentDeliveryDetailVOItem), var_export($shipmentDeliveryResultVOShipmentDeliveryDetailVOItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentDeliveryDetailVO property can only contain items of type \StructType\ShipmentDeliveryDetailVO, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentDeliveryDetailVO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentDeliveryDetailVO[] $shipmentDeliveryDetailVO
     * @return \StructType\ShipmentDeliveryResultVO
     */
    public function setShipmentDeliveryDetailVO(array $shipmentDeliveryDetailVO = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentDeliveryDetailVOArrayErrorMessage = self::validateShipmentDeliveryDetailVOForArrayConstraintsFromSetShipmentDeliveryDetailVO($shipmentDeliveryDetailVO))) {
            throw new \InvalidArgumentException($shipmentDeliveryDetailVOArrayErrorMessage, __LINE__);
        }
        if (is_null($shipmentDeliveryDetailVO) || (is_array($shipmentDeliveryDetailVO) && empty($shipmentDeliveryDetailVO))) {
            unset($this->shipmentDeliveryDetailVO);
        } else {
            $this->shipmentDeliveryDetailVO = $shipmentDeliveryDetailVO;
        }
        return $this;
    }
    /**
     * Add item to shipmentDeliveryDetailVO value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentDeliveryDetailVO $item
     * @return \StructType\ShipmentDeliveryResultVO
     */
    public function addToShipmentDeliveryDetailVO(\StructType\ShipmentDeliveryDetailVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentDeliveryDetailVO) {
            throw new \InvalidArgumentException(sprintf('The shipmentDeliveryDetailVO property can only contain items of type \StructType\ShipmentDeliveryDetailVO, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipmentDeliveryDetailVO[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentDeliveryResultVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
