<?php

namespace LaGangaServices\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WS_DatosFactura StructType
 * @package LaGangaServices
 * @subpackage Structs
 */
class LaGangaServicesWS_DatosFactura extends AbstractStructBase
{
    /**
     * The Pedido
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Pedido;
    /**
     * The CostoEnvio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CostoEnvio;
    /**
     * The RetiraCliente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RetiraCliente;
    /**
     * The Monto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Monto;
    /**
     * The NumeroCuotas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumeroCuotas;
    /**
     * The FormaPago
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormaPago;
    /**
     * The Vendedor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vendedor;
    /**
     * The TipoIdentificacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoIdentificacion;
    /**
     * The Identificacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Identificacion;
    /**
     * The Apellidos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Apellidos;
    /**
     * The Nombres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nombres;
    /**
     * The Direccion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Direccion;
    /**
     * The Telefono
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telefono;
    /**
     * The Mail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mail;
    /**
     * The CodigoUsuario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoUsuario;
    /**
     * The Provincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Provincia;
    /**
     * The Canton
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Canton;
    /**
     * The Ciudad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ciudad;
    /**
     * The OtraUbicacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtraUbicacion;
    /**
     * The DireccionEnvio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DireccionEnvio;
    /**
     * The ReferenciaDireccionEnvio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenciaDireccionEnvio;
    /**
     * The TelefonoContacto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TelefonoContacto;
    /**
     * The CedulaReceptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CedulaReceptor;
    /**
     * The NombresReceptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NombresReceptor;
    /**
     * The SucursalRetiraCliente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SucursalRetiraCliente;
    /**
     * The CodigoBanco
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoBanco;
    /**
     * The CodigoTarjeta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoTarjeta;
    /**
     * The CodigoPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPlan;
    /**
     * The NumeroTarjeta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroTarjeta;
    /**
     * The NumeroAutorizacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroAutorizacion;
    /**
     * The NumeroVoucher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroVoucher;
    /**
     * The NumeroLote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroLote;
    /**
     * The Detalle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \LaGangaServices\ArrayType\LaGangaServicesArrayOfWS_DatosFactura_Productos
     */
    public $Detalle;
    /**
     * Constructor method for WS_DatosFactura
     * @uses LaGangaServicesWS_DatosFactura::setPedido()
     * @uses LaGangaServicesWS_DatosFactura::setCostoEnvio()
     * @uses LaGangaServicesWS_DatosFactura::setRetiraCliente()
     * @uses LaGangaServicesWS_DatosFactura::setMonto()
     * @uses LaGangaServicesWS_DatosFactura::setNumeroCuotas()
     * @uses LaGangaServicesWS_DatosFactura::setFormaPago()
     * @uses LaGangaServicesWS_DatosFactura::setVendedor()
     * @uses LaGangaServicesWS_DatosFactura::setTipoIdentificacion()
     * @uses LaGangaServicesWS_DatosFactura::setIdentificacion()
     * @uses LaGangaServicesWS_DatosFactura::setApellidos()
     * @uses LaGangaServicesWS_DatosFactura::setNombres()
     * @uses LaGangaServicesWS_DatosFactura::setDireccion()
     * @uses LaGangaServicesWS_DatosFactura::setTelefono()
     * @uses LaGangaServicesWS_DatosFactura::setMail()
     * @uses LaGangaServicesWS_DatosFactura::setCodigoUsuario()
     * @uses LaGangaServicesWS_DatosFactura::setProvincia()
     * @uses LaGangaServicesWS_DatosFactura::setCanton()
     * @uses LaGangaServicesWS_DatosFactura::setCiudad()
     * @uses LaGangaServicesWS_DatosFactura::setOtraUbicacion()
     * @uses LaGangaServicesWS_DatosFactura::setDireccionEnvio()
     * @uses LaGangaServicesWS_DatosFactura::setReferenciaDireccionEnvio()
     * @uses LaGangaServicesWS_DatosFactura::setTelefonoContacto()
     * @uses LaGangaServicesWS_DatosFactura::setCedulaReceptor()
     * @uses LaGangaServicesWS_DatosFactura::setNombresReceptor()
     * @uses LaGangaServicesWS_DatosFactura::setSucursalRetiraCliente()
     * @uses LaGangaServicesWS_DatosFactura::setCodigoBanco()
     * @uses LaGangaServicesWS_DatosFactura::setCodigoTarjeta()
     * @uses LaGangaServicesWS_DatosFactura::setCodigoPlan()
     * @uses LaGangaServicesWS_DatosFactura::setNumeroTarjeta()
     * @uses LaGangaServicesWS_DatosFactura::setNumeroAutorizacion()
     * @uses LaGangaServicesWS_DatosFactura::setNumeroVoucher()
     * @uses LaGangaServicesWS_DatosFactura::setNumeroLote()
     * @uses LaGangaServicesWS_DatosFactura::setDetalle()
     * @param int $pedido
     * @param float $costoEnvio
     * @param bool $retiraCliente
     * @param float $monto
     * @param int $numeroCuotas
     * @param string $formaPago
     * @param string $vendedor
     * @param string $tipoIdentificacion
     * @param string $identificacion
     * @param string $apellidos
     * @param string $nombres
     * @param string $direccion
     * @param string $telefono
     * @param string $mail
     * @param string $codigoUsuario
     * @param string $provincia
     * @param string $canton
     * @param string $ciudad
     * @param string $otraUbicacion
     * @param string $direccionEnvio
     * @param string $referenciaDireccionEnvio
     * @param string $telefonoContacto
     * @param string $cedulaReceptor
     * @param string $nombresReceptor
     * @param string $sucursalRetiraCliente
     * @param string $codigoBanco
     * @param string $codigoTarjeta
     * @param string $codigoPlan
     * @param string $numeroTarjeta
     * @param string $numeroAutorizacion
     * @param string $numeroVoucher
     * @param string $numeroLote
     * @param \LaGangaServices\ArrayType\LaGangaServicesArrayOfWS_DatosFactura_Productos $detalle
     */
    public function __construct($pedido = null, $costoEnvio = null, $retiraCliente = null, $monto = null, $numeroCuotas = null, $formaPago = null, $vendedor = null, $tipoIdentificacion = null, $identificacion = null, $apellidos = null, $nombres = null, $direccion = null, $telefono = null, $mail = null, $codigoUsuario = null, $provincia = null, $canton = null, $ciudad = null, $otraUbicacion = null, $direccionEnvio = null, $referenciaDireccionEnvio = null, $telefonoContacto = null, $cedulaReceptor = null, $nombresReceptor = null, $sucursalRetiraCliente = null, $codigoBanco = null, $codigoTarjeta = null, $codigoPlan = null, $numeroTarjeta = null, $numeroAutorizacion = null, $numeroVoucher = null, $numeroLote = null, \LaGangaServices\ArrayType\LaGangaServicesArrayOfWS_DatosFactura_Productos $detalle = null)
    {
        $this
            ->setPedido($pedido)
            ->setCostoEnvio($costoEnvio)
            ->setRetiraCliente($retiraCliente)
            ->setMonto($monto)
            ->setNumeroCuotas($numeroCuotas)
            ->setFormaPago($formaPago)
            ->setVendedor($vendedor)
            ->setTipoIdentificacion($tipoIdentificacion)
            ->setIdentificacion($identificacion)
            ->setApellidos($apellidos)
            ->setNombres($nombres)
            ->setDireccion($direccion)
            ->setTelefono($telefono)
            ->setMail($mail)
            ->setCodigoUsuario($codigoUsuario)
            ->setProvincia($provincia)
            ->setCanton($canton)
            ->setCiudad($ciudad)
            ->setOtraUbicacion($otraUbicacion)
            ->setDireccionEnvio($direccionEnvio)
            ->setReferenciaDireccionEnvio($referenciaDireccionEnvio)
            ->setTelefonoContacto($telefonoContacto)
            ->setCedulaReceptor($cedulaReceptor)
            ->setNombresReceptor($nombresReceptor)
            ->setSucursalRetiraCliente($sucursalRetiraCliente)
            ->setCodigoBanco($codigoBanco)
            ->setCodigoTarjeta($codigoTarjeta)
            ->setCodigoPlan($codigoPlan)
            ->setNumeroTarjeta($numeroTarjeta)
            ->setNumeroAutorizacion($numeroAutorizacion)
            ->setNumeroVoucher($numeroVoucher)
            ->setNumeroLote($numeroLote)
            ->setDetalle($detalle);
    }
    /**
     * Get Pedido value
     * @return int
     */
    public function getPedido()
    {
        return $this->Pedido;
    }
    /**
     * Set Pedido value
     * @param int $pedido
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setPedido($pedido = null)
    {
        // validation for constraint: int
        if (!is_null($pedido) && !(is_int($pedido) || ctype_digit($pedido))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pedido, true), gettype($pedido)), __LINE__);
        }
        $this->Pedido = $pedido;
        return $this;
    }
    /**
     * Get CostoEnvio value
     * @return float
     */
    public function getCostoEnvio()
    {
        return $this->CostoEnvio;
    }
    /**
     * Set CostoEnvio value
     * @param float $costoEnvio
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setCostoEnvio($costoEnvio = null)
    {
        // validation for constraint: float
        if (!is_null($costoEnvio) && !(is_float($costoEnvio) || is_numeric($costoEnvio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costoEnvio, true), gettype($costoEnvio)), __LINE__);
        }
        $this->CostoEnvio = $costoEnvio;
        return $this;
    }
    /**
     * Get RetiraCliente value
     * @return bool
     */
    public function getRetiraCliente()
    {
        return $this->RetiraCliente;
    }
    /**
     * Set RetiraCliente value
     * @param bool $retiraCliente
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setRetiraCliente($retiraCliente = null)
    {
        // validation for constraint: boolean
        if (!is_null($retiraCliente) && !is_bool($retiraCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retiraCliente, true), gettype($retiraCliente)), __LINE__);
        }
        $this->RetiraCliente = $retiraCliente;
        return $this;
    }
    /**
     * Get Monto value
     * @return float
     */
    public function getMonto()
    {
        return $this->Monto;
    }
    /**
     * Set Monto value
     * @param float $monto
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setMonto($monto = null)
    {
        // validation for constraint: float
        if (!is_null($monto) && !(is_float($monto) || is_numeric($monto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($monto, true), gettype($monto)), __LINE__);
        }
        $this->Monto = $monto;
        return $this;
    }
    /**
     * Get NumeroCuotas value
     * @return int
     */
    public function getNumeroCuotas()
    {
        return $this->NumeroCuotas;
    }
    /**
     * Set NumeroCuotas value
     * @param int $numeroCuotas
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setNumeroCuotas($numeroCuotas = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCuotas) && !(is_int($numeroCuotas) || ctype_digit($numeroCuotas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroCuotas, true), gettype($numeroCuotas)), __LINE__);
        }
        $this->NumeroCuotas = $numeroCuotas;
        return $this;
    }
    /**
     * Get FormaPago value
     * @return string|null
     */
    public function getFormaPago()
    {
        return $this->FormaPago;
    }
    /**
     * Set FormaPago value
     * @param string $formaPago
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setFormaPago($formaPago = null)
    {
        // validation for constraint: string
        if (!is_null($formaPago) && !is_string($formaPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formaPago, true), gettype($formaPago)), __LINE__);
        }
        $this->FormaPago = $formaPago;
        return $this;
    }
    /**
     * Get Vendedor value
     * @return string|null
     */
    public function getVendedor()
    {
        return $this->Vendedor;
    }
    /**
     * Set Vendedor value
     * @param string $vendedor
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setVendedor($vendedor = null)
    {
        // validation for constraint: string
        if (!is_null($vendedor) && !is_string($vendedor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendedor, true), gettype($vendedor)), __LINE__);
        }
        $this->Vendedor = $vendedor;
        return $this;
    }
    /**
     * Get TipoIdentificacion value
     * @return string|null
     */
    public function getTipoIdentificacion()
    {
        return $this->TipoIdentificacion;
    }
    /**
     * Set TipoIdentificacion value
     * @param string $tipoIdentificacion
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setTipoIdentificacion($tipoIdentificacion = null)
    {
        // validation for constraint: string
        if (!is_null($tipoIdentificacion) && !is_string($tipoIdentificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoIdentificacion, true), gettype($tipoIdentificacion)), __LINE__);
        }
        $this->TipoIdentificacion = $tipoIdentificacion;
        return $this;
    }
    /**
     * Get Identificacion value
     * @return string|null
     */
    public function getIdentificacion()
    {
        return $this->Identificacion;
    }
    /**
     * Set Identificacion value
     * @param string $identificacion
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setIdentificacion($identificacion = null)
    {
        // validation for constraint: string
        if (!is_null($identificacion) && !is_string($identificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificacion, true), gettype($identificacion)), __LINE__);
        }
        $this->Identificacion = $identificacion;
        return $this;
    }
    /**
     * Get Apellidos value
     * @return string|null
     */
    public function getApellidos()
    {
        return $this->Apellidos;
    }
    /**
     * Set Apellidos value
     * @param string $apellidos
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setApellidos($apellidos = null)
    {
        // validation for constraint: string
        if (!is_null($apellidos) && !is_string($apellidos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apellidos, true), gettype($apellidos)), __LINE__);
        }
        $this->Apellidos = $apellidos;
        return $this;
    }
    /**
     * Get Nombres value
     * @return string|null
     */
    public function getNombres()
    {
        return $this->Nombres;
    }
    /**
     * Set Nombres value
     * @param string $nombres
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setNombres($nombres = null)
    {
        // validation for constraint: string
        if (!is_null($nombres) && !is_string($nombres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombres, true), gettype($nombres)), __LINE__);
        }
        $this->Nombres = $nombres;
        return $this;
    }
    /**
     * Get Direccion value
     * @return string|null
     */
    public function getDireccion()
    {
        return $this->Direccion;
    }
    /**
     * Set Direccion value
     * @param string $direccion
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setDireccion($direccion = null)
    {
        // validation for constraint: string
        if (!is_null($direccion) && !is_string($direccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direccion, true), gettype($direccion)), __LINE__);
        }
        $this->Direccion = $direccion;
        return $this;
    }
    /**
     * Get Telefono value
     * @return string|null
     */
    public function getTelefono()
    {
        return $this->Telefono;
    }
    /**
     * Set Telefono value
     * @param string $telefono
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setTelefono($telefono = null)
    {
        // validation for constraint: string
        if (!is_null($telefono) && !is_string($telefono)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefono, true), gettype($telefono)), __LINE__);
        }
        $this->Telefono = $telefono;
        return $this;
    }
    /**
     * Get Mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->Mail;
    }
    /**
     * Set Mail value
     * @param string $mail
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        $this->Mail = $mail;
        return $this;
    }
    /**
     * Get CodigoUsuario value
     * @return string|null
     */
    public function getCodigoUsuario()
    {
        return $this->CodigoUsuario;
    }
    /**
     * Set CodigoUsuario value
     * @param string $codigoUsuario
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setCodigoUsuario($codigoUsuario = null)
    {
        // validation for constraint: string
        if (!is_null($codigoUsuario) && !is_string($codigoUsuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoUsuario, true), gettype($codigoUsuario)), __LINE__);
        }
        $this->CodigoUsuario = $codigoUsuario;
        return $this;
    }
    /**
     * Get Provincia value
     * @return string|null
     */
    public function getProvincia()
    {
        return $this->Provincia;
    }
    /**
     * Set Provincia value
     * @param string $provincia
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        $this->Provincia = $provincia;
        return $this;
    }
    /**
     * Get Canton value
     * @return string|null
     */
    public function getCanton()
    {
        return $this->Canton;
    }
    /**
     * Set Canton value
     * @param string $canton
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setCanton($canton = null)
    {
        // validation for constraint: string
        if (!is_null($canton) && !is_string($canton)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canton, true), gettype($canton)), __LINE__);
        }
        $this->Canton = $canton;
        return $this;
    }
    /**
     * Get Ciudad value
     * @return string|null
     */
    public function getCiudad()
    {
        return $this->Ciudad;
    }
    /**
     * Set Ciudad value
     * @param string $ciudad
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setCiudad($ciudad = null)
    {
        // validation for constraint: string
        if (!is_null($ciudad) && !is_string($ciudad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ciudad, true), gettype($ciudad)), __LINE__);
        }
        $this->Ciudad = $ciudad;
        return $this;
    }
    /**
     * Get OtraUbicacion value
     * @return string|null
     */
    public function getOtraUbicacion()
    {
        return $this->OtraUbicacion;
    }
    /**
     * Set OtraUbicacion value
     * @param string $otraUbicacion
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setOtraUbicacion($otraUbicacion = null)
    {
        // validation for constraint: string
        if (!is_null($otraUbicacion) && !is_string($otraUbicacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otraUbicacion, true), gettype($otraUbicacion)), __LINE__);
        }
        $this->OtraUbicacion = $otraUbicacion;
        return $this;
    }
    /**
     * Get DireccionEnvio value
     * @return string|null
     */
    public function getDireccionEnvio()
    {
        return $this->DireccionEnvio;
    }
    /**
     * Set DireccionEnvio value
     * @param string $direccionEnvio
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setDireccionEnvio($direccionEnvio = null)
    {
        // validation for constraint: string
        if (!is_null($direccionEnvio) && !is_string($direccionEnvio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direccionEnvio, true), gettype($direccionEnvio)), __LINE__);
        }
        $this->DireccionEnvio = $direccionEnvio;
        return $this;
    }
    /**
     * Get ReferenciaDireccionEnvio value
     * @return string|null
     */
    public function getReferenciaDireccionEnvio()
    {
        return $this->ReferenciaDireccionEnvio;
    }
    /**
     * Set ReferenciaDireccionEnvio value
     * @param string $referenciaDireccionEnvio
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setReferenciaDireccionEnvio($referenciaDireccionEnvio = null)
    {
        // validation for constraint: string
        if (!is_null($referenciaDireccionEnvio) && !is_string($referenciaDireccionEnvio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenciaDireccionEnvio, true), gettype($referenciaDireccionEnvio)), __LINE__);
        }
        $this->ReferenciaDireccionEnvio = $referenciaDireccionEnvio;
        return $this;
    }
    /**
     * Get TelefonoContacto value
     * @return string|null
     */
    public function getTelefonoContacto()
    {
        return $this->TelefonoContacto;
    }
    /**
     * Set TelefonoContacto value
     * @param string $telefonoContacto
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setTelefonoContacto($telefonoContacto = null)
    {
        // validation for constraint: string
        if (!is_null($telefonoContacto) && !is_string($telefonoContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefonoContacto, true), gettype($telefonoContacto)), __LINE__);
        }
        $this->TelefonoContacto = $telefonoContacto;
        return $this;
    }
    /**
     * Get CedulaReceptor value
     * @return string|null
     */
    public function getCedulaReceptor()
    {
        return $this->CedulaReceptor;
    }
    /**
     * Set CedulaReceptor value
     * @param string $cedulaReceptor
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setCedulaReceptor($cedulaReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($cedulaReceptor) && !is_string($cedulaReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cedulaReceptor, true), gettype($cedulaReceptor)), __LINE__);
        }
        $this->CedulaReceptor = $cedulaReceptor;
        return $this;
    }
    /**
     * Get NombresReceptor value
     * @return string|null
     */
    public function getNombresReceptor()
    {
        return $this->NombresReceptor;
    }
    /**
     * Set NombresReceptor value
     * @param string $nombresReceptor
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setNombresReceptor($nombresReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($nombresReceptor) && !is_string($nombresReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombresReceptor, true), gettype($nombresReceptor)), __LINE__);
        }
        $this->NombresReceptor = $nombresReceptor;
        return $this;
    }
    /**
     * Get SucursalRetiraCliente value
     * @return string|null
     */
    public function getSucursalRetiraCliente()
    {
        return $this->SucursalRetiraCliente;
    }
    /**
     * Set SucursalRetiraCliente value
     * @param string $sucursalRetiraCliente
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setSucursalRetiraCliente($sucursalRetiraCliente = null)
    {
        // validation for constraint: string
        if (!is_null($sucursalRetiraCliente) && !is_string($sucursalRetiraCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sucursalRetiraCliente, true), gettype($sucursalRetiraCliente)), __LINE__);
        }
        $this->SucursalRetiraCliente = $sucursalRetiraCliente;
        return $this;
    }
    /**
     * Get CodigoBanco value
     * @return string|null
     */
    public function getCodigoBanco()
    {
        return $this->CodigoBanco;
    }
    /**
     * Set CodigoBanco value
     * @param string $codigoBanco
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setCodigoBanco($codigoBanco = null)
    {
        // validation for constraint: string
        if (!is_null($codigoBanco) && !is_string($codigoBanco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoBanco, true), gettype($codigoBanco)), __LINE__);
        }
        $this->CodigoBanco = $codigoBanco;
        return $this;
    }
    /**
     * Get CodigoTarjeta value
     * @return string|null
     */
    public function getCodigoTarjeta()
    {
        return $this->CodigoTarjeta;
    }
    /**
     * Set CodigoTarjeta value
     * @param string $codigoTarjeta
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setCodigoTarjeta($codigoTarjeta = null)
    {
        // validation for constraint: string
        if (!is_null($codigoTarjeta) && !is_string($codigoTarjeta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoTarjeta, true), gettype($codigoTarjeta)), __LINE__);
        }
        $this->CodigoTarjeta = $codigoTarjeta;
        return $this;
    }
    /**
     * Get CodigoPlan value
     * @return string|null
     */
    public function getCodigoPlan()
    {
        return $this->CodigoPlan;
    }
    /**
     * Set CodigoPlan value
     * @param string $codigoPlan
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setCodigoPlan($codigoPlan = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPlan) && !is_string($codigoPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPlan, true), gettype($codigoPlan)), __LINE__);
        }
        $this->CodigoPlan = $codigoPlan;
        return $this;
    }
    /**
     * Get NumeroTarjeta value
     * @return string|null
     */
    public function getNumeroTarjeta()
    {
        return $this->NumeroTarjeta;
    }
    /**
     * Set NumeroTarjeta value
     * @param string $numeroTarjeta
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setNumeroTarjeta($numeroTarjeta = null)
    {
        // validation for constraint: string
        if (!is_null($numeroTarjeta) && !is_string($numeroTarjeta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroTarjeta, true), gettype($numeroTarjeta)), __LINE__);
        }
        $this->NumeroTarjeta = $numeroTarjeta;
        return $this;
    }
    /**
     * Get NumeroAutorizacion value
     * @return string|null
     */
    public function getNumeroAutorizacion()
    {
        return $this->NumeroAutorizacion;
    }
    /**
     * Set NumeroAutorizacion value
     * @param string $numeroAutorizacion
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setNumeroAutorizacion($numeroAutorizacion = null)
    {
        // validation for constraint: string
        if (!is_null($numeroAutorizacion) && !is_string($numeroAutorizacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroAutorizacion, true), gettype($numeroAutorizacion)), __LINE__);
        }
        $this->NumeroAutorizacion = $numeroAutorizacion;
        return $this;
    }
    /**
     * Get NumeroVoucher value
     * @return string|null
     */
    public function getNumeroVoucher()
    {
        return $this->NumeroVoucher;
    }
    /**
     * Set NumeroVoucher value
     * @param string $numeroVoucher
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setNumeroVoucher($numeroVoucher = null)
    {
        // validation for constraint: string
        if (!is_null($numeroVoucher) && !is_string($numeroVoucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroVoucher, true), gettype($numeroVoucher)), __LINE__);
        }
        $this->NumeroVoucher = $numeroVoucher;
        return $this;
    }
    /**
     * Get NumeroLote value
     * @return string|null
     */
    public function getNumeroLote()
    {
        return $this->NumeroLote;
    }
    /**
     * Set NumeroLote value
     * @param string $numeroLote
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setNumeroLote($numeroLote = null)
    {
        // validation for constraint: string
        if (!is_null($numeroLote) && !is_string($numeroLote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroLote, true), gettype($numeroLote)), __LINE__);
        }
        $this->NumeroLote = $numeroLote;
        return $this;
    }
    /**
     * Get Detalle value
     * @return \LaGangaServices\ArrayType\LaGangaServicesArrayOfWS_DatosFactura_Productos|null
     */
    public function getDetalle()
    {
        return $this->Detalle;
    }
    /**
     * Set Detalle value
     * @param \LaGangaServices\ArrayType\LaGangaServicesArrayOfWS_DatosFactura_Productos $detalle
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public function setDetalle(\LaGangaServices\ArrayType\LaGangaServicesArrayOfWS_DatosFactura_Productos $detalle = null)
    {
        $this->Detalle = $detalle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
