<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for changeSingleInstance operation/method
 */
if ($change->changeSingleInstance(new \StructType\XECMDocumentChangeSingleInstanceRequest()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for addSingleInstance operation/method
 */
if ($add->addSingleInstance(new \StructType\XECMDocumentAddSingleInstanceRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addComment operation/method
 */
if ($add->addComment(new \StructType\XECMDocumentAddCommentRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addFolderEntry operation/method
 */
if ($add->addFolderEntry(new \StructType\XECMDocumentAddFolderEntryRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addKeywordEntry operation/method
 */
if ($add->addKeywordEntry(new \StructType\XECMDocumentAddKeywordEntryRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addVisa operation/method
 */
if ($add->addVisa(new \StructType\XECMDocumentAddVisaRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addLink operation/method
 */
if ($add->addLink(new \StructType\XECMDocumentAddLinkRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getListAll operation/method
 */
if ($get->getListAll(new \StructType\XECMDocumentGetListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSingleInstance operation/method
 */
if ($get->getSingleInstance(new \StructType\XECMDocumentGetSingleInstanceRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCommentListAll operation/method
 */
if ($get->getCommentListAll(new \StructType\XECMDocumentGetCommentListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFolderListAll operation/method
 */
if ($get->getFolderListAll(new \StructType\XECMDocumentGetFolderListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getKeywordListAll operation/method
 */
if ($get->getKeywordListAll(new \StructType\XECMDocumentGetKeywordListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVersionOrLinkedDocumentListAll operation/method
 */
if ($get->getVersionOrLinkedDocumentListAll(new \StructType\XECMDocumentGetVersionOrLinkedDocumentListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVisaListAll operation/method
 */
if ($get->getVisaListAll(new \StructType\XECMDocumentGetVisaListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteSingleInstanceAndObject operation/method
 */
if ($delete->deleteSingleInstanceAndObject(new \StructType\XECMDocumentDeleteSingleInstanceAndObjectRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteFolderEntry operation/method
 */
if ($delete->deleteFolderEntry(new \StructType\XECMDocumentDeleteFolderEntryRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteKeywordEntry operation/method
 */
if ($delete->deleteKeywordEntry(new \StructType\XECMDocumentDeleteKeywordEntryRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteComment operation/method
 */
if ($delete->deleteComment(new \StructType\XECMDocumentDeleteCommentRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteLink operation/method
 */
if ($delete->deleteLink(new \StructType\XECMDocumentDeleteLinkRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteVisa operation/method
 */
if ($delete->deleteVisa(new \StructType\XECMDocumentDeleteVisaRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Print ServiceType
 */
$print = new \ServiceType\_Print($options);
/**
 * Sample call for printObject operation/method
 */
if ($print->printObject(new \StructType\XECMDocumentPrintObjectRequest()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendMailObject operation/method
 */
if ($send->sendMailObject(new \StructType\XECMDocumentSendMailObjectRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
