<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XECMDocumentRestoreObjectOutputData StructType
 * @subpackage Structs
 */
class XECMDocumentRestoreObjectOutputData extends AbstractStructBase
{
    /**
     * The ReturnedStatus
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $ReturnedStatus;
    /**
     * The DDAPI146SReturnCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DDAPI146SReturnCode;
    /**
     * The documentId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $documentId;
    /**
     * The primaryStorageHostAlias
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $primaryStorageHostAlias;
    /**
     * The primaryStorageClientAlias
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $primaryStorageClientAlias;
    /**
     * The primaryStoragePath
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $primaryStoragePath;
    /**
     * The DDAPI146SOutputReserved
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DDAPI146SOutputReserved;
    /**
     * Constructor method for XECMDocumentRestoreObjectOutputData
     * @uses XECMDocumentRestoreObjectOutputData::setReturnedStatus()
     * @uses XECMDocumentRestoreObjectOutputData::setDDAPI146SReturnCode()
     * @uses XECMDocumentRestoreObjectOutputData::setDocumentId()
     * @uses XECMDocumentRestoreObjectOutputData::setPrimaryStorageHostAlias()
     * @uses XECMDocumentRestoreObjectOutputData::setPrimaryStorageClientAlias()
     * @uses XECMDocumentRestoreObjectOutputData::setPrimaryStoragePath()
     * @uses XECMDocumentRestoreObjectOutputData::setDDAPI146SOutputReserved()
     * @param string $returnedStatus
     * @param string $dDAPI146SReturnCode
     * @param string $documentId
     * @param string $primaryStorageHostAlias
     * @param string $primaryStorageClientAlias
     * @param string $primaryStoragePath
     * @param string $dDAPI146SOutputReserved
     */
    public function __construct($returnedStatus = null, $dDAPI146SReturnCode = null, $documentId = null, $primaryStorageHostAlias = null, $primaryStorageClientAlias = null, $primaryStoragePath = null, $dDAPI146SOutputReserved = null)
    {
        $this
            ->setReturnedStatus($returnedStatus)
            ->setDDAPI146SReturnCode($dDAPI146SReturnCode)
            ->setDocumentId($documentId)
            ->setPrimaryStorageHostAlias($primaryStorageHostAlias)
            ->setPrimaryStorageClientAlias($primaryStorageClientAlias)
            ->setPrimaryStoragePath($primaryStoragePath)
            ->setDDAPI146SOutputReserved($dDAPI146SOutputReserved);
    }
    /**
     * Get ReturnedStatus value
     * @return string|null
     */
    public function getReturnedStatus()
    {
        return $this->ReturnedStatus;
    }
    /**
     * Set ReturnedStatus value
     * @param string $returnedStatus
     * @return \StructType\XECMDocumentRestoreObjectOutputData
     */
    public function setReturnedStatus($returnedStatus = null)
    {
        // validation for constraint: string
        if (!is_null($returnedStatus) && !is_string($returnedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnedStatus, true), gettype($returnedStatus)), __LINE__);
        }
        $this->ReturnedStatus = $returnedStatus;
        return $this;
    }
    /**
     * Get DDAPI146SReturnCode value
     * @return string|null
     */
    public function getDDAPI146SReturnCode()
    {
        return $this->DDAPI146SReturnCode;
    }
    /**
     * Set DDAPI146SReturnCode value
     * @param string $dDAPI146SReturnCode
     * @return \StructType\XECMDocumentRestoreObjectOutputData
     */
    public function setDDAPI146SReturnCode($dDAPI146SReturnCode = null)
    {
        // validation for constraint: string
        if (!is_null($dDAPI146SReturnCode) && !is_string($dDAPI146SReturnCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dDAPI146SReturnCode, true), gettype($dDAPI146SReturnCode)), __LINE__);
        }
        $this->DDAPI146SReturnCode = $dDAPI146SReturnCode;
        return $this;
    }
    /**
     * Get documentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->documentId;
    }
    /**
     * Set documentId value
     * @param string $documentId
     * @return \StructType\XECMDocumentRestoreObjectOutputData
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->documentId = $documentId;
        return $this;
    }
    /**
     * Get primaryStorageHostAlias value
     * @return string|null
     */
    public function getPrimaryStorageHostAlias()
    {
        return $this->primaryStorageHostAlias;
    }
    /**
     * Set primaryStorageHostAlias value
     * @param string $primaryStorageHostAlias
     * @return \StructType\XECMDocumentRestoreObjectOutputData
     */
    public function setPrimaryStorageHostAlias($primaryStorageHostAlias = null)
    {
        // validation for constraint: string
        if (!is_null($primaryStorageHostAlias) && !is_string($primaryStorageHostAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryStorageHostAlias, true), gettype($primaryStorageHostAlias)), __LINE__);
        }
        $this->primaryStorageHostAlias = $primaryStorageHostAlias;
        return $this;
    }
    /**
     * Get primaryStorageClientAlias value
     * @return string|null
     */
    public function getPrimaryStorageClientAlias()
    {
        return $this->primaryStorageClientAlias;
    }
    /**
     * Set primaryStorageClientAlias value
     * @param string $primaryStorageClientAlias
     * @return \StructType\XECMDocumentRestoreObjectOutputData
     */
    public function setPrimaryStorageClientAlias($primaryStorageClientAlias = null)
    {
        // validation for constraint: string
        if (!is_null($primaryStorageClientAlias) && !is_string($primaryStorageClientAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryStorageClientAlias, true), gettype($primaryStorageClientAlias)), __LINE__);
        }
        $this->primaryStorageClientAlias = $primaryStorageClientAlias;
        return $this;
    }
    /**
     * Get primaryStoragePath value
     * @return string|null
     */
    public function getPrimaryStoragePath()
    {
        return $this->primaryStoragePath;
    }
    /**
     * Set primaryStoragePath value
     * @param string $primaryStoragePath
     * @return \StructType\XECMDocumentRestoreObjectOutputData
     */
    public function setPrimaryStoragePath($primaryStoragePath = null)
    {
        // validation for constraint: string
        if (!is_null($primaryStoragePath) && !is_string($primaryStoragePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryStoragePath, true), gettype($primaryStoragePath)), __LINE__);
        }
        $this->primaryStoragePath = $primaryStoragePath;
        return $this;
    }
    /**
     * Get DDAPI146SOutputReserved value
     * @return string|null
     */
    public function getDDAPI146SOutputReserved()
    {
        return $this->DDAPI146SOutputReserved;
    }
    /**
     * Set DDAPI146SOutputReserved value
     * @param string $dDAPI146SOutputReserved
     * @return \StructType\XECMDocumentRestoreObjectOutputData
     */
    public function setDDAPI146SOutputReserved($dDAPI146SOutputReserved = null)
    {
        // validation for constraint: string
        if (!is_null($dDAPI146SOutputReserved) && !is_string($dDAPI146SOutputReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dDAPI146SOutputReserved, true), gettype($dDAPI146SOutputReserved)), __LINE__);
        }
        $this->DDAPI146SOutputReserved = $dDAPI146SOutputReserved;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XECMDocumentRestoreObjectOutputData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
