<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XECMDocumentExportObjectOutputData StructType
 * @subpackage Structs
 */
class XECMDocumentExportObjectOutputData extends AbstractStructBase
{
    /**
     * The ReturnedStatus
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $ReturnedStatus;
    /**
     * The DDAPI135SReturnCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DDAPI135SReturnCode;
    /**
     * The DDAPI135SOutputReserved
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DDAPI135SOutputReserved;
    /**
     * Constructor method for XECMDocumentExportObjectOutputData
     * @uses XECMDocumentExportObjectOutputData::setReturnedStatus()
     * @uses XECMDocumentExportObjectOutputData::setDDAPI135SReturnCode()
     * @uses XECMDocumentExportObjectOutputData::setDDAPI135SOutputReserved()
     * @param string $returnedStatus
     * @param string $dDAPI135SReturnCode
     * @param string $dDAPI135SOutputReserved
     */
    public function __construct($returnedStatus = null, $dDAPI135SReturnCode = null, $dDAPI135SOutputReserved = null)
    {
        $this
            ->setReturnedStatus($returnedStatus)
            ->setDDAPI135SReturnCode($dDAPI135SReturnCode)
            ->setDDAPI135SOutputReserved($dDAPI135SOutputReserved);
    }
    /**
     * Get ReturnedStatus value
     * @return string|null
     */
    public function getReturnedStatus()
    {
        return $this->ReturnedStatus;
    }
    /**
     * Set ReturnedStatus value
     * @param string $returnedStatus
     * @return \StructType\XECMDocumentExportObjectOutputData
     */
    public function setReturnedStatus($returnedStatus = null)
    {
        // validation for constraint: string
        if (!is_null($returnedStatus) && !is_string($returnedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnedStatus, true), gettype($returnedStatus)), __LINE__);
        }
        $this->ReturnedStatus = $returnedStatus;
        return $this;
    }
    /**
     * Get DDAPI135SReturnCode value
     * @return string|null
     */
    public function getDDAPI135SReturnCode()
    {
        return $this->DDAPI135SReturnCode;
    }
    /**
     * Set DDAPI135SReturnCode value
     * @param string $dDAPI135SReturnCode
     * @return \StructType\XECMDocumentExportObjectOutputData
     */
    public function setDDAPI135SReturnCode($dDAPI135SReturnCode = null)
    {
        // validation for constraint: string
        if (!is_null($dDAPI135SReturnCode) && !is_string($dDAPI135SReturnCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dDAPI135SReturnCode, true), gettype($dDAPI135SReturnCode)), __LINE__);
        }
        $this->DDAPI135SReturnCode = $dDAPI135SReturnCode;
        return $this;
    }
    /**
     * Get DDAPI135SOutputReserved value
     * @return string|null
     */
    public function getDDAPI135SOutputReserved()
    {
        return $this->DDAPI135SOutputReserved;
    }
    /**
     * Set DDAPI135SOutputReserved value
     * @param string $dDAPI135SOutputReserved
     * @return \StructType\XECMDocumentExportObjectOutputData
     */
    public function setDDAPI135SOutputReserved($dDAPI135SOutputReserved = null)
    {
        // validation for constraint: string
        if (!is_null($dDAPI135SOutputReserved) && !is_string($dDAPI135SOutputReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dDAPI135SOutputReserved, true), gettype($dDAPI135SOutputReserved)), __LINE__);
        }
        $this->DDAPI135SOutputReserved = $dDAPI135SOutputReserved;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XECMDocumentExportObjectOutputData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
