<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XECMDocumentExportObjectInputData StructType
 * @subpackage Structs
 */
class XECMDocumentExportObjectInputData extends AbstractStructBase
{
    /**
     * The APIUserID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $APIUserID;
    /**
     * The APIActionCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $APIActionCode;
    /**
     * The apiEnvironmentName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $apiEnvironmentName;
    /**
     * The userIdLong
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userIdLong;
    /**
     * The apiRightsCheck
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $apiRightsCheck;
    /**
     * The documentId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $documentId;
    /**
     * The databaseId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $databaseId;
    /**
     * The documentTypeId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $documentTypeId;
    /**
     * The keywordTypeId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $keywordTypeId;
    /**
     * The keywordValue
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $keywordValue;
    /**
     * The documentNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $documentNumber;
    /**
     * The documentVersionNumberSearch
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $documentVersionNumberSearch;
    /**
     * The ExportDirectory
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExportDirectory;
    /**
     * The ExportFileName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExportFileName;
    /**
     * The SynchronousExport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SynchronousExport;
    /**
     * The ConversionBeforeExportation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConversionBeforeExportation;
    /**
     * The DDAPI135SInputReserved
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DDAPI135SInputReserved;
    /**
     * Constructor method for XECMDocumentExportObjectInputData
     * @uses XECMDocumentExportObjectInputData::setAPIUserID()
     * @uses XECMDocumentExportObjectInputData::setAPIActionCode()
     * @uses XECMDocumentExportObjectInputData::setApiEnvironmentName()
     * @uses XECMDocumentExportObjectInputData::setUserIdLong()
     * @uses XECMDocumentExportObjectInputData::setApiRightsCheck()
     * @uses XECMDocumentExportObjectInputData::setDocumentId()
     * @uses XECMDocumentExportObjectInputData::setDatabaseId()
     * @uses XECMDocumentExportObjectInputData::setDocumentTypeId()
     * @uses XECMDocumentExportObjectInputData::setKeywordTypeId()
     * @uses XECMDocumentExportObjectInputData::setKeywordValue()
     * @uses XECMDocumentExportObjectInputData::setDocumentNumber()
     * @uses XECMDocumentExportObjectInputData::setDocumentVersionNumberSearch()
     * @uses XECMDocumentExportObjectInputData::setExportDirectory()
     * @uses XECMDocumentExportObjectInputData::setExportFileName()
     * @uses XECMDocumentExportObjectInputData::setSynchronousExport()
     * @uses XECMDocumentExportObjectInputData::setConversionBeforeExportation()
     * @uses XECMDocumentExportObjectInputData::setDDAPI135SInputReserved()
     * @param string $aPIUserID
     * @param string $aPIActionCode
     * @param string $apiEnvironmentName
     * @param string $userIdLong
     * @param string $apiRightsCheck
     * @param string $documentId
     * @param string $databaseId
     * @param string $documentTypeId
     * @param string $keywordTypeId
     * @param string $keywordValue
     * @param string $documentNumber
     * @param string $documentVersionNumberSearch
     * @param string $exportDirectory
     * @param string $exportFileName
     * @param string $synchronousExport
     * @param string $conversionBeforeExportation
     * @param string $dDAPI135SInputReserved
     */
    public function __construct($aPIUserID = null, $aPIActionCode = null, $apiEnvironmentName = null, $userIdLong = null, $apiRightsCheck = null, $documentId = null, $databaseId = null, $documentTypeId = null, $keywordTypeId = null, $keywordValue = null, $documentNumber = null, $documentVersionNumberSearch = null, $exportDirectory = null, $exportFileName = null, $synchronousExport = null, $conversionBeforeExportation = null, $dDAPI135SInputReserved = null)
    {
        $this
            ->setAPIUserID($aPIUserID)
            ->setAPIActionCode($aPIActionCode)
            ->setApiEnvironmentName($apiEnvironmentName)
            ->setUserIdLong($userIdLong)
            ->setApiRightsCheck($apiRightsCheck)
            ->setDocumentId($documentId)
            ->setDatabaseId($databaseId)
            ->setDocumentTypeId($documentTypeId)
            ->setKeywordTypeId($keywordTypeId)
            ->setKeywordValue($keywordValue)
            ->setDocumentNumber($documentNumber)
            ->setDocumentVersionNumberSearch($documentVersionNumberSearch)
            ->setExportDirectory($exportDirectory)
            ->setExportFileName($exportFileName)
            ->setSynchronousExport($synchronousExport)
            ->setConversionBeforeExportation($conversionBeforeExportation)
            ->setDDAPI135SInputReserved($dDAPI135SInputReserved);
    }
    /**
     * Get APIUserID value
     * @return string|null
     */
    public function getAPIUserID()
    {
        return $this->APIUserID;
    }
    /**
     * Set APIUserID value
     * @param string $aPIUserID
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setAPIUserID($aPIUserID = null)
    {
        // validation for constraint: string
        if (!is_null($aPIUserID) && !is_string($aPIUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPIUserID, true), gettype($aPIUserID)), __LINE__);
        }
        $this->APIUserID = $aPIUserID;
        return $this;
    }
    /**
     * Get APIActionCode value
     * @return string|null
     */
    public function getAPIActionCode()
    {
        return $this->APIActionCode;
    }
    /**
     * Set APIActionCode value
     * @param string $aPIActionCode
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setAPIActionCode($aPIActionCode = null)
    {
        // validation for constraint: string
        if (!is_null($aPIActionCode) && !is_string($aPIActionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPIActionCode, true), gettype($aPIActionCode)), __LINE__);
        }
        $this->APIActionCode = $aPIActionCode;
        return $this;
    }
    /**
     * Get apiEnvironmentName value
     * @return string|null
     */
    public function getApiEnvironmentName()
    {
        return $this->apiEnvironmentName;
    }
    /**
     * Set apiEnvironmentName value
     * @param string $apiEnvironmentName
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setApiEnvironmentName($apiEnvironmentName = null)
    {
        // validation for constraint: string
        if (!is_null($apiEnvironmentName) && !is_string($apiEnvironmentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiEnvironmentName, true), gettype($apiEnvironmentName)), __LINE__);
        }
        $this->apiEnvironmentName = $apiEnvironmentName;
        return $this;
    }
    /**
     * Get userIdLong value
     * @return string|null
     */
    public function getUserIdLong()
    {
        return $this->userIdLong;
    }
    /**
     * Set userIdLong value
     * @param string $userIdLong
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setUserIdLong($userIdLong = null)
    {
        // validation for constraint: string
        if (!is_null($userIdLong) && !is_string($userIdLong)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userIdLong, true), gettype($userIdLong)), __LINE__);
        }
        $this->userIdLong = $userIdLong;
        return $this;
    }
    /**
     * Get apiRightsCheck value
     * @return string|null
     */
    public function getApiRightsCheck()
    {
        return $this->apiRightsCheck;
    }
    /**
     * Set apiRightsCheck value
     * @param string $apiRightsCheck
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setApiRightsCheck($apiRightsCheck = null)
    {
        // validation for constraint: string
        if (!is_null($apiRightsCheck) && !is_string($apiRightsCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiRightsCheck, true), gettype($apiRightsCheck)), __LINE__);
        }
        $this->apiRightsCheck = $apiRightsCheck;
        return $this;
    }
    /**
     * Get documentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->documentId;
    }
    /**
     * Set documentId value
     * @param string $documentId
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->documentId = $documentId;
        return $this;
    }
    /**
     * Get databaseId value
     * @return string|null
     */
    public function getDatabaseId()
    {
        return $this->databaseId;
    }
    /**
     * Set databaseId value
     * @param string $databaseId
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setDatabaseId($databaseId = null)
    {
        // validation for constraint: string
        if (!is_null($databaseId) && !is_string($databaseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($databaseId, true), gettype($databaseId)), __LINE__);
        }
        $this->databaseId = $databaseId;
        return $this;
    }
    /**
     * Get documentTypeId value
     * @return string|null
     */
    public function getDocumentTypeId()
    {
        return $this->documentTypeId;
    }
    /**
     * Set documentTypeId value
     * @param string $documentTypeId
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setDocumentTypeId($documentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeId) && !is_string($documentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeId, true), gettype($documentTypeId)), __LINE__);
        }
        $this->documentTypeId = $documentTypeId;
        return $this;
    }
    /**
     * Get keywordTypeId value
     * @return string|null
     */
    public function getKeywordTypeId()
    {
        return $this->keywordTypeId;
    }
    /**
     * Set keywordTypeId value
     * @param string $keywordTypeId
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setKeywordTypeId($keywordTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($keywordTypeId) && !is_string($keywordTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keywordTypeId, true), gettype($keywordTypeId)), __LINE__);
        }
        $this->keywordTypeId = $keywordTypeId;
        return $this;
    }
    /**
     * Get keywordValue value
     * @return string|null
     */
    public function getKeywordValue()
    {
        return $this->keywordValue;
    }
    /**
     * Set keywordValue value
     * @param string $keywordValue
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setKeywordValue($keywordValue = null)
    {
        // validation for constraint: string
        if (!is_null($keywordValue) && !is_string($keywordValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keywordValue, true), gettype($keywordValue)), __LINE__);
        }
        $this->keywordValue = $keywordValue;
        return $this;
    }
    /**
     * Get documentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param string $documentNumber
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get documentVersionNumberSearch value
     * @return string|null
     */
    public function getDocumentVersionNumberSearch()
    {
        return $this->documentVersionNumberSearch;
    }
    /**
     * Set documentVersionNumberSearch value
     * @param string $documentVersionNumberSearch
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setDocumentVersionNumberSearch($documentVersionNumberSearch = null)
    {
        // validation for constraint: string
        if (!is_null($documentVersionNumberSearch) && !is_string($documentVersionNumberSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentVersionNumberSearch, true), gettype($documentVersionNumberSearch)), __LINE__);
        }
        $this->documentVersionNumberSearch = $documentVersionNumberSearch;
        return $this;
    }
    /**
     * Get ExportDirectory value
     * @return string|null
     */
    public function getExportDirectory()
    {
        return $this->ExportDirectory;
    }
    /**
     * Set ExportDirectory value
     * @param string $exportDirectory
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setExportDirectory($exportDirectory = null)
    {
        // validation for constraint: string
        if (!is_null($exportDirectory) && !is_string($exportDirectory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportDirectory, true), gettype($exportDirectory)), __LINE__);
        }
        $this->ExportDirectory = $exportDirectory;
        return $this;
    }
    /**
     * Get ExportFileName value
     * @return string|null
     */
    public function getExportFileName()
    {
        return $this->ExportFileName;
    }
    /**
     * Set ExportFileName value
     * @param string $exportFileName
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setExportFileName($exportFileName = null)
    {
        // validation for constraint: string
        if (!is_null($exportFileName) && !is_string($exportFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportFileName, true), gettype($exportFileName)), __LINE__);
        }
        $this->ExportFileName = $exportFileName;
        return $this;
    }
    /**
     * Get SynchronousExport value
     * @return string|null
     */
    public function getSynchronousExport()
    {
        return $this->SynchronousExport;
    }
    /**
     * Set SynchronousExport value
     * @param string $synchronousExport
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setSynchronousExport($synchronousExport = null)
    {
        // validation for constraint: string
        if (!is_null($synchronousExport) && !is_string($synchronousExport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronousExport, true), gettype($synchronousExport)), __LINE__);
        }
        $this->SynchronousExport = $synchronousExport;
        return $this;
    }
    /**
     * Get ConversionBeforeExportation value
     * @return string|null
     */
    public function getConversionBeforeExportation()
    {
        return $this->ConversionBeforeExportation;
    }
    /**
     * Set ConversionBeforeExportation value
     * @param string $conversionBeforeExportation
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setConversionBeforeExportation($conversionBeforeExportation = null)
    {
        // validation for constraint: string
        if (!is_null($conversionBeforeExportation) && !is_string($conversionBeforeExportation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversionBeforeExportation, true), gettype($conversionBeforeExportation)), __LINE__);
        }
        $this->ConversionBeforeExportation = $conversionBeforeExportation;
        return $this;
    }
    /**
     * Get DDAPI135SInputReserved value
     * @return string|null
     */
    public function getDDAPI135SInputReserved()
    {
        return $this->DDAPI135SInputReserved;
    }
    /**
     * Set DDAPI135SInputReserved value
     * @param string $dDAPI135SInputReserved
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public function setDDAPI135SInputReserved($dDAPI135SInputReserved = null)
    {
        // validation for constraint: string
        if (!is_null($dDAPI135SInputReserved) && !is_string($dDAPI135SInputReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dDAPI135SInputReserved, true), gettype($dDAPI135SInputReserved)), __LINE__);
        }
        $this->DDAPI135SInputReserved = $dDAPI135SInputReserved;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XECMDocumentExportObjectInputData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
