<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getListAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentGetListRequest $parametersXECMDocumentGetList
     * @return \StructType\XECMDocumentGetListResponse|bool
     */
    public function getListAll(\StructType\XECMDocumentGetListRequest $parametersXECMDocumentGetList)
    {
        try {
            $this->setResult($this->getSoapClient()->getListAll($parametersXECMDocumentGetList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSingleInstance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentGetSingleInstanceRequest $parametersXECMDocumentGetSingleInstance
     * @return \StructType\XECMDocumentGetSingleInstanceResponse|bool
     */
    public function getSingleInstance(\StructType\XECMDocumentGetSingleInstanceRequest $parametersXECMDocumentGetSingleInstance)
    {
        try {
            $this->setResult($this->getSoapClient()->getSingleInstance($parametersXECMDocumentGetSingleInstance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCommentListAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentGetCommentListRequest $parametersXECMDocumentGetCommentList
     * @return \StructType\XECMDocumentGetCommentListResponse|bool
     */
    public function getCommentListAll(\StructType\XECMDocumentGetCommentListRequest $parametersXECMDocumentGetCommentList)
    {
        try {
            $this->setResult($this->getSoapClient()->getCommentListAll($parametersXECMDocumentGetCommentList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFolderListAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentGetFolderListRequest $parametersXECMDocumentGetFolderList
     * @return \StructType\XECMDocumentGetFolderListResponse|bool
     */
    public function getFolderListAll(\StructType\XECMDocumentGetFolderListRequest $parametersXECMDocumentGetFolderList)
    {
        try {
            $this->setResult($this->getSoapClient()->getFolderListAll($parametersXECMDocumentGetFolderList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKeywordListAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentGetKeywordListRequest $parametersXECMDocumentGetKeywordList
     * @return \StructType\XECMDocumentGetKeywordListResponse|bool
     */
    public function getKeywordListAll(\StructType\XECMDocumentGetKeywordListRequest $parametersXECMDocumentGetKeywordList)
    {
        try {
            $this->setResult($this->getSoapClient()->getKeywordListAll($parametersXECMDocumentGetKeywordList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVersionOrLinkedDocumentListAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentGetVersionOrLinkedDocumentListRequest $parametersXECMDocumentGetVersionOrLinkedDocumentList
     * @return \StructType\XECMDocumentGetVersionOrLinkedDocumentListResponse|bool
     */
    public function getVersionOrLinkedDocumentListAll(\StructType\XECMDocumentGetVersionOrLinkedDocumentListRequest $parametersXECMDocumentGetVersionOrLinkedDocumentList)
    {
        try {
            $this->setResult($this->getSoapClient()->getVersionOrLinkedDocumentListAll($parametersXECMDocumentGetVersionOrLinkedDocumentList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVisaListAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentGetVisaListRequest $parametersXECMDocumentGetVisaList
     * @return \StructType\XECMDocumentGetVisaListResponse|bool
     */
    public function getVisaListAll(\StructType\XECMDocumentGetVisaListRequest $parametersXECMDocumentGetVisaList)
    {
        try {
            $this->setResult($this->getSoapClient()->getVisaListAll($parametersXECMDocumentGetVisaList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\XECMDocumentGetCommentListResponse|\StructType\XECMDocumentGetFolderListResponse|\StructType\XECMDocumentGetKeywordListResponse|\StructType\XECMDocumentGetListResponse|\StructType\XECMDocumentGetSingleInstanceResponse|\StructType\XECMDocumentGetVersionOrLinkedDocumentListResponse|\StructType\XECMDocumentGetVisaListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
