<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named changeSingleInstance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentChangeSingleInstanceRequest $parametersXECMDocumentChangeSingleInstance
     * @return \StructType\XECMDocumentChangeSingleInstanceResponse|bool
     */
    public function changeSingleInstance(\StructType\XECMDocumentChangeSingleInstanceRequest $parametersXECMDocumentChangeSingleInstance)
    {
        try {
            $this->setResult($this->getSoapClient()->changeSingleInstance($parametersXECMDocumentChangeSingleInstance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\XECMDocumentChangeSingleInstanceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
