<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteSingleInstanceAndObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentDeleteSingleInstanceAndObjectRequest $parametersXECMDocumentDeleteSingleInstanceAndObject
     * @return \StructType\XECMDocumentDeleteSingleInstanceAndObjectResponse|bool
     */
    public function deleteSingleInstanceAndObject(\StructType\XECMDocumentDeleteSingleInstanceAndObjectRequest $parametersXECMDocumentDeleteSingleInstanceAndObject)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteSingleInstanceAndObject($parametersXECMDocumentDeleteSingleInstanceAndObject));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteFolderEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentDeleteFolderEntryRequest $parametersXECMDocumentDeleteFolderEntry
     * @return \StructType\XECMDocumentDeleteFolderEntryResponse|bool
     */
    public function deleteFolderEntry(\StructType\XECMDocumentDeleteFolderEntryRequest $parametersXECMDocumentDeleteFolderEntry)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteFolderEntry($parametersXECMDocumentDeleteFolderEntry));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteKeywordEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentDeleteKeywordEntryRequest $parametersXECMDocumentDeleteKeywordEntry
     * @return \StructType\XECMDocumentDeleteKeywordEntryResponse|bool
     */
    public function deleteKeywordEntry(\StructType\XECMDocumentDeleteKeywordEntryRequest $parametersXECMDocumentDeleteKeywordEntry)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteKeywordEntry($parametersXECMDocumentDeleteKeywordEntry));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteComment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentDeleteCommentRequest $parametersXECMDocumentDeleteComment
     * @return \StructType\XECMDocumentDeleteCommentResponse|bool
     */
    public function deleteComment(\StructType\XECMDocumentDeleteCommentRequest $parametersXECMDocumentDeleteComment)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteComment($parametersXECMDocumentDeleteComment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteLink
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentDeleteLinkRequest $parametersXECMDocumentDeleteLink
     * @return \StructType\XECMDocumentDeleteLinkResponse|bool
     */
    public function deleteLink(\StructType\XECMDocumentDeleteLinkRequest $parametersXECMDocumentDeleteLink)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteLink($parametersXECMDocumentDeleteLink));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteVisa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentDeleteVisaRequest $parametersXECMDocumentDeleteVisa
     * @return \StructType\XECMDocumentDeleteVisaResponse|bool
     */
    public function deleteVisa(\StructType\XECMDocumentDeleteVisaRequest $parametersXECMDocumentDeleteVisa)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteVisa($parametersXECMDocumentDeleteVisa));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\XECMDocumentDeleteCommentResponse|\StructType\XECMDocumentDeleteFolderEntryResponse|\StructType\XECMDocumentDeleteKeywordEntryResponse|\StructType\XECMDocumentDeleteLinkResponse|\StructType\XECMDocumentDeleteSingleInstanceAndObjectResponse|\StructType\XECMDocumentDeleteVisaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
