<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addSingleInstance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentAddSingleInstanceRequest $parametersXECMDocumentAddSingleInstance
     * @return \StructType\XECMDocumentAddSingleInstanceResponse|bool
     */
    public function addSingleInstance(\StructType\XECMDocumentAddSingleInstanceRequest $parametersXECMDocumentAddSingleInstance)
    {
        try {
            $this->setResult($this->getSoapClient()->addSingleInstance($parametersXECMDocumentAddSingleInstance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addComment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentAddCommentRequest $parametersXECMDocumentAddComment
     * @return \StructType\XECMDocumentAddCommentResponse|bool
     */
    public function addComment(\StructType\XECMDocumentAddCommentRequest $parametersXECMDocumentAddComment)
    {
        try {
            $this->setResult($this->getSoapClient()->addComment($parametersXECMDocumentAddComment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFolderEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentAddFolderEntryRequest $parametersXECMDocumentAddFolderEntry
     * @return \StructType\XECMDocumentAddFolderEntryResponse|bool
     */
    public function addFolderEntry(\StructType\XECMDocumentAddFolderEntryRequest $parametersXECMDocumentAddFolderEntry)
    {
        try {
            $this->setResult($this->getSoapClient()->addFolderEntry($parametersXECMDocumentAddFolderEntry));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addKeywordEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentAddKeywordEntryRequest $parametersXECMDocumentAddKeywordEntry
     * @return \StructType\XECMDocumentAddKeywordEntryResponse|bool
     */
    public function addKeywordEntry(\StructType\XECMDocumentAddKeywordEntryRequest $parametersXECMDocumentAddKeywordEntry)
    {
        try {
            $this->setResult($this->getSoapClient()->addKeywordEntry($parametersXECMDocumentAddKeywordEntry));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVisa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentAddVisaRequest $parametersXECMDocumentAddVisa
     * @return \StructType\XECMDocumentAddVisaResponse|bool
     */
    public function addVisa(\StructType\XECMDocumentAddVisaRequest $parametersXECMDocumentAddVisa)
    {
        try {
            $this->setResult($this->getSoapClient()->addVisa($parametersXECMDocumentAddVisa));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLink
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XECMDocumentAddLinkRequest $parametersXECMDocumentAddLink
     * @return \StructType\XECMDocumentAddLinkResponse|bool
     */
    public function addLink(\StructType\XECMDocumentAddLinkRequest $parametersXECMDocumentAddLink)
    {
        try {
            $this->setResult($this->getSoapClient()->addLink($parametersXECMDocumentAddLink));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\XECMDocumentAddCommentResponse|\StructType\XECMDocumentAddFolderEntryResponse|\StructType\XECMDocumentAddKeywordEntryResponse|\StructType\XECMDocumentAddLinkResponse|\StructType\XECMDocumentAddSingleInstanceResponse|\StructType\XECMDocumentAddVisaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
