<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://m.almaceneslaganga.com/wsPruebaFact/WebServiceGangaAut.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://m.almaceneslaganga.com/wsPruebaFact/WebServiceGangaAut.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \LaGangaServices\LaGangaServicesClassMap::get(),
);
/**
 * Samples for Registrar ServiceType
 */
$registrar = new \LaGangaServices\ServiceType\LaGangaServicesRegistrar($options);
$registrar->setSoapHeaderValidarUsuario(new \LaGangaServices\StructType\LaGangaServicesValidarUsuario());
/**
 * Sample call for RegistrarPedido operation/method
 */
if ($registrar->RegistrarPedido(new \LaGangaServices\StructType\LaGangaServicesRegistrarPedido()) !== false) {
    print_r($registrar->getResult());
} else {
    print_r($registrar->getLastError());
}
/**
 * Sample call for RegistrarFacturaInternet operation/method
 */
if ($registrar->RegistrarFacturaInternet(new \LaGangaServices\StructType\LaGangaServicesRegistrarFacturaInternet()) !== false) {
    print_r($registrar->getResult());
} else {
    print_r($registrar->getLastError());
}
/**
 * Sample call for RegistrarCambioPrecio operation/method
 */
if ($registrar->RegistrarCambioPrecio(new \LaGangaServices\StructType\LaGangaServicesRegistrarCambioPrecio()) !== false) {
    print_r($registrar->getResult());
} else {
    print_r($registrar->getLastError());
}
/**
 * Samples for Rechazar ServiceType
 */
$rechazar = new \LaGangaServices\ServiceType\LaGangaServicesRechazar($options);
$rechazar->setSoapHeaderValidarUsuario(new \LaGangaServices\StructType\LaGangaServicesValidarUsuario());
/**
 * Sample call for RechazarFacturaInternet operation/method
 */
if ($rechazar->RechazarFacturaInternet(new \LaGangaServices\StructType\LaGangaServicesRechazarFacturaInternet()) !== false) {
    print_r($rechazar->getResult());
} else {
    print_r($rechazar->getLastError());
}
