<?php

namespace LaGangaServices\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WS_DatosFactura_Productos StructType
 * @package LaGangaServices
 * @subpackage Structs
 */
class LaGangaServicesWS_DatosFactura_Productos extends AbstractStructBase
{
    /**
     * The Pedido
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Pedido;
    /**
     * The CantidadProducto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CantidadProducto;
    /**
     * The PrecioUnitario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecioUnitario;
    /**
     * The PrecioTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecioTotal;
    /**
     * The Descuento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Descuento;
    /**
     * The ValorIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ValorIVA;
    /**
     * The PorcentajeIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PorcentajeIVA;
    /**
     * The CodigoProducto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoProducto;
    /**
     * The NombreProducto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NombreProducto;
    /**
     * The SerieProducto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerieProducto;
    /**
     * Constructor method for WS_DatosFactura_Productos
     * @uses LaGangaServicesWS_DatosFactura_Productos::setPedido()
     * @uses LaGangaServicesWS_DatosFactura_Productos::setCantidadProducto()
     * @uses LaGangaServicesWS_DatosFactura_Productos::setPrecioUnitario()
     * @uses LaGangaServicesWS_DatosFactura_Productos::setPrecioTotal()
     * @uses LaGangaServicesWS_DatosFactura_Productos::setDescuento()
     * @uses LaGangaServicesWS_DatosFactura_Productos::setValorIVA()
     * @uses LaGangaServicesWS_DatosFactura_Productos::setPorcentajeIVA()
     * @uses LaGangaServicesWS_DatosFactura_Productos::setCodigoProducto()
     * @uses LaGangaServicesWS_DatosFactura_Productos::setNombreProducto()
     * @uses LaGangaServicesWS_DatosFactura_Productos::setSerieProducto()
     * @param int $pedido
     * @param float $cantidadProducto
     * @param float $precioUnitario
     * @param float $precioTotal
     * @param float $descuento
     * @param float $valorIVA
     * @param float $porcentajeIVA
     * @param string $codigoProducto
     * @param string $nombreProducto
     * @param string $serieProducto
     */
    public function __construct($pedido = null, $cantidadProducto = null, $precioUnitario = null, $precioTotal = null, $descuento = null, $valorIVA = null, $porcentajeIVA = null, $codigoProducto = null, $nombreProducto = null, $serieProducto = null)
    {
        $this
            ->setPedido($pedido)
            ->setCantidadProducto($cantidadProducto)
            ->setPrecioUnitario($precioUnitario)
            ->setPrecioTotal($precioTotal)
            ->setDescuento($descuento)
            ->setValorIVA($valorIVA)
            ->setPorcentajeIVA($porcentajeIVA)
            ->setCodigoProducto($codigoProducto)
            ->setNombreProducto($nombreProducto)
            ->setSerieProducto($serieProducto);
    }
    /**
     * Get Pedido value
     * @return int
     */
    public function getPedido()
    {
        return $this->Pedido;
    }
    /**
     * Set Pedido value
     * @param int $pedido
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public function setPedido($pedido = null)
    {
        // validation for constraint: int
        if (!is_null($pedido) && !(is_int($pedido) || ctype_digit($pedido))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pedido, true), gettype($pedido)), __LINE__);
        }
        $this->Pedido = $pedido;
        return $this;
    }
    /**
     * Get CantidadProducto value
     * @return float
     */
    public function getCantidadProducto()
    {
        return $this->CantidadProducto;
    }
    /**
     * Set CantidadProducto value
     * @param float $cantidadProducto
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public function setCantidadProducto($cantidadProducto = null)
    {
        // validation for constraint: float
        if (!is_null($cantidadProducto) && !(is_float($cantidadProducto) || is_numeric($cantidadProducto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cantidadProducto, true), gettype($cantidadProducto)), __LINE__);
        }
        $this->CantidadProducto = $cantidadProducto;
        return $this;
    }
    /**
     * Get PrecioUnitario value
     * @return float
     */
    public function getPrecioUnitario()
    {
        return $this->PrecioUnitario;
    }
    /**
     * Set PrecioUnitario value
     * @param float $precioUnitario
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public function setPrecioUnitario($precioUnitario = null)
    {
        // validation for constraint: float
        if (!is_null($precioUnitario) && !(is_float($precioUnitario) || is_numeric($precioUnitario))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precioUnitario, true), gettype($precioUnitario)), __LINE__);
        }
        $this->PrecioUnitario = $precioUnitario;
        return $this;
    }
    /**
     * Get PrecioTotal value
     * @return float
     */
    public function getPrecioTotal()
    {
        return $this->PrecioTotal;
    }
    /**
     * Set PrecioTotal value
     * @param float $precioTotal
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public function setPrecioTotal($precioTotal = null)
    {
        // validation for constraint: float
        if (!is_null($precioTotal) && !(is_float($precioTotal) || is_numeric($precioTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precioTotal, true), gettype($precioTotal)), __LINE__);
        }
        $this->PrecioTotal = $precioTotal;
        return $this;
    }
    /**
     * Get Descuento value
     * @return float
     */
    public function getDescuento()
    {
        return $this->Descuento;
    }
    /**
     * Set Descuento value
     * @param float $descuento
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public function setDescuento($descuento = null)
    {
        // validation for constraint: float
        if (!is_null($descuento) && !(is_float($descuento) || is_numeric($descuento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($descuento, true), gettype($descuento)), __LINE__);
        }
        $this->Descuento = $descuento;
        return $this;
    }
    /**
     * Get ValorIVA value
     * @return float
     */
    public function getValorIVA()
    {
        return $this->ValorIVA;
    }
    /**
     * Set ValorIVA value
     * @param float $valorIVA
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public function setValorIVA($valorIVA = null)
    {
        // validation for constraint: float
        if (!is_null($valorIVA) && !(is_float($valorIVA) || is_numeric($valorIVA))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorIVA, true), gettype($valorIVA)), __LINE__);
        }
        $this->ValorIVA = $valorIVA;
        return $this;
    }
    /**
     * Get PorcentajeIVA value
     * @return float
     */
    public function getPorcentajeIVA()
    {
        return $this->PorcentajeIVA;
    }
    /**
     * Set PorcentajeIVA value
     * @param float $porcentajeIVA
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public function setPorcentajeIVA($porcentajeIVA = null)
    {
        // validation for constraint: float
        if (!is_null($porcentajeIVA) && !(is_float($porcentajeIVA) || is_numeric($porcentajeIVA))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($porcentajeIVA, true), gettype($porcentajeIVA)), __LINE__);
        }
        $this->PorcentajeIVA = $porcentajeIVA;
        return $this;
    }
    /**
     * Get CodigoProducto value
     * @return string|null
     */
    public function getCodigoProducto()
    {
        return $this->CodigoProducto;
    }
    /**
     * Set CodigoProducto value
     * @param string $codigoProducto
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public function setCodigoProducto($codigoProducto = null)
    {
        // validation for constraint: string
        if (!is_null($codigoProducto) && !is_string($codigoProducto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoProducto, true), gettype($codigoProducto)), __LINE__);
        }
        $this->CodigoProducto = $codigoProducto;
        return $this;
    }
    /**
     * Get NombreProducto value
     * @return string|null
     */
    public function getNombreProducto()
    {
        return $this->NombreProducto;
    }
    /**
     * Set NombreProducto value
     * @param string $nombreProducto
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public function setNombreProducto($nombreProducto = null)
    {
        // validation for constraint: string
        if (!is_null($nombreProducto) && !is_string($nombreProducto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombreProducto, true), gettype($nombreProducto)), __LINE__);
        }
        $this->NombreProducto = $nombreProducto;
        return $this;
    }
    /**
     * Get SerieProducto value
     * @return string|null
     */
    public function getSerieProducto()
    {
        return $this->SerieProducto;
    }
    /**
     * Set SerieProducto value
     * @param string $serieProducto
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public function setSerieProducto($serieProducto = null)
    {
        // validation for constraint: string
        if (!is_null($serieProducto) && !is_string($serieProducto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serieProducto, true), gettype($serieProducto)), __LINE__);
        }
        $this->SerieProducto = $serieProducto;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LaGangaServices\StructType\LaGangaServicesWS_DatosFactura_Productos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
