<?php

namespace LaGangaServices\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rechazar ServiceType
 * @package LaGangaServices
 * @subpackage Services
 */
class LaGangaServicesRechazar extends AbstractSoapClientBase
{
    /**
     * Sets the ValidarUsuario SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \LaGangaServices\StructType\LaGangaServicesValidarUsuario $validarUsuario
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderValidarUsuario(\LaGangaServices\StructType\LaGangaServicesValidarUsuario $validarUsuario, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ValidarUsuario', $validarUsuario, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RechazarFacturaInternet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidarUsuario
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \LaGangaServices\StructType\LaGangaServicesValidarUsuario
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LaGangaServices\StructType\LaGangaServicesRechazarFacturaInternet $parameters
     * @return \LaGangaServices\StructType\LaGangaServicesRechazarFacturaInternetResponse|bool
     */
    public function RechazarFacturaInternet(\LaGangaServices\StructType\LaGangaServicesRechazarFacturaInternet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RechazarFacturaInternet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LaGangaServices\StructType\LaGangaServicesRechazarFacturaInternetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
