<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrieveLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveLogin $parameters
     * @return \StructType\RetrieveLoginResponse|bool
     */
    public function RetrieveLogin(\StructType\RetrieveLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAllMemberData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAllMemberData $parameters
     * @return \StructType\RetrieveAllMemberDataResponse|bool
     */
    public function RetrieveAllMemberData(\StructType\RetrieveAllMemberData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAllMemberData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveSingleMemberData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveSingleMemberData $parameters
     * @return \StructType\RetrieveSingleMemberDataResponse|bool
     */
    public function RetrieveSingleMemberData(\StructType\RetrieveSingleMemberData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveSingleMemberData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAllMemberAvailability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAllMemberAvailability $parameters
     * @return \StructType\RetrieveAllMemberAvailabilityResponse|bool
     */
    public function RetrieveAllMemberAvailability(\StructType\RetrieveAllMemberAvailability $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAllMemberAvailability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveSingleMemberAvailability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveSingleMemberAvailability $parameters
     * @return \StructType\RetrieveSingleMemberAvailabilityResponse|bool
     */
    public function RetrieveSingleMemberAvailability(\StructType\RetrieveSingleMemberAvailability $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveSingleMemberAvailability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveAllMemberAvailabilityResponse|\StructType\RetrieveAllMemberDataResponse|\StructType\RetrieveLoginResponse|\StructType\RetrieveSingleMemberAvailabilityResponse|\StructType\RetrieveSingleMemberDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
