<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMemberSearch ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMemberSearch
 * @subpackage Arrays
 */
class ArrayOfMemberSearch extends AbstractStructArrayBase
{
    /**
     * The MemberSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MemberSearch[]
     */
    public $MemberSearch;
    /**
     * Constructor method for ArrayOfMemberSearch
     * @uses ArrayOfMemberSearch::setMemberSearch()
     * @param \StructType\MemberSearch[] $memberSearch
     */
    public function __construct(array $memberSearch = array())
    {
        $this
            ->setMemberSearch($memberSearch);
    }
    /**
     * Get MemberSearch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MemberSearch[]|null
     */
    public function getMemberSearch()
    {
        return isset($this->MemberSearch) ? $this->MemberSearch : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMemberSearch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMemberSearch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMemberSearchForArrayConstraintsFromSetMemberSearch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMemberSearchMemberSearchItem) {
            // validation for constraint: itemType
            if (!$arrayOfMemberSearchMemberSearchItem instanceof \StructType\MemberSearch) {
                $invalidValues[] = is_object($arrayOfMemberSearchMemberSearchItem) ? get_class($arrayOfMemberSearchMemberSearchItem) : sprintf('%s(%s)', gettype($arrayOfMemberSearchMemberSearchItem), var_export($arrayOfMemberSearchMemberSearchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MemberSearch property can only contain items of type \StructType\MemberSearch, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MemberSearch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MemberSearch[] $memberSearch
     * @return \ArrayType\ArrayOfMemberSearch
     */
    public function setMemberSearch(array $memberSearch = array())
    {
        // validation for constraint: array
        if ('' !== ($memberSearchArrayErrorMessage = self::validateMemberSearchForArrayConstraintsFromSetMemberSearch($memberSearch))) {
            throw new \InvalidArgumentException($memberSearchArrayErrorMessage, __LINE__);
        }
        if (is_null($memberSearch) || (is_array($memberSearch) && empty($memberSearch))) {
            unset($this->MemberSearch);
        } else {
            $this->MemberSearch = $memberSearch;
        }
        return $this;
    }
    /**
     * Add item to MemberSearch value
     * @throws \InvalidArgumentException
     * @param \StructType\MemberSearch $item
     * @return \ArrayType\ArrayOfMemberSearch
     */
    public function addToMemberSearch(\StructType\MemberSearch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MemberSearch) {
            throw new \InvalidArgumentException(sprintf('The MemberSearch property can only contain items of type \StructType\MemberSearch, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MemberSearch[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MemberSearch|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MemberSearch|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MemberSearch|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MemberSearch|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MemberSearch|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MemberSearch
     */
    public function getAttributeName()
    {
        return 'MemberSearch';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMemberSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
