<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberContactsById StructType
 * @subpackage Structs
 */
class MemberContactsById extends AbstractStructBase
{
    /**
     * The webServiceCredentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceCredential
     */
    public $webServiceCredentials;
    /**
     * The memberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $memberId;
    /**
     * Constructor method for MemberContactsById
     * @uses MemberContactsById::setWebServiceCredentials()
     * @uses MemberContactsById::setMemberId()
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @param int $memberId
     */
    public function __construct(\StructType\ServiceCredential $webServiceCredentials = null, $memberId = null)
    {
        $this
            ->setWebServiceCredentials($webServiceCredentials)
            ->setMemberId($memberId);
    }
    /**
     * Get webServiceCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceCredential|null
     */
    public function getWebServiceCredentials()
    {
        return isset($this->webServiceCredentials) ? $this->webServiceCredentials : null;
    }
    /**
     * Set webServiceCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @return \StructType\MemberContactsById
     */
    public function setWebServiceCredentials(\StructType\ServiceCredential $webServiceCredentials = null)
    {
        if (is_null($webServiceCredentials) || (is_array($webServiceCredentials) && empty($webServiceCredentials))) {
            unset($this->webServiceCredentials);
        } else {
            $this->webServiceCredentials = $webServiceCredentials;
        }
        return $this;
    }
    /**
     * Get memberId value
     * @return int|null
     */
    public function getMemberId()
    {
        return $this->memberId;
    }
    /**
     * Set memberId value
     * @param int $memberId
     * @return \StructType\MemberContactsById
     */
    public function setMemberId($memberId = null)
    {
        // validation for constraint: int
        if (!is_null($memberId) && !(is_int($memberId) || ctype_digit($memberId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberId, true), gettype($memberId)), __LINE__);
        }
        $this->memberId = $memberId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberContactsById
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
