<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceCredential StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceCredential
 * @subpackage Structs
 */
class ServiceCredential extends AbstractStructBase
{
    /**
     * The IpAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IpAddress;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for ServiceCredential
     * @uses ServiceCredential::setIpAddress()
     * @uses ServiceCredential::setPassword()
     * @uses ServiceCredential::setUserName()
     * @param string $ipAddress
     * @param string $password
     * @param string $userName
     */
    public function __construct($ipAddress = null, $password = null, $userName = null)
    {
        $this
            ->setIpAddress($ipAddress)
            ->setPassword($password)
            ->setUserName($userName);
    }
    /**
     * Get IpAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->IpAddress;
    }
    /**
     * Set IpAddress value
     * @param string $ipAddress
     * @return \StructType\ServiceCredential
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        $this->IpAddress = $ipAddress;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\ServiceCredential
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\ServiceCredential
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceCredential
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
