<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoginDetail
 * @subpackage Structs
 */
class LoginDetail extends AbstractStructBase
{
    /**
     * The FullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullName;
    /**
     * The Identifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Identifier;
    /**
     * The IsAvalabilityEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvalabilityEnabled;
    /**
     * The IsClosed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsClosed;
    /**
     * The IsEmployer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsEmployer;
    /**
     * The IsMember
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMember;
    /**
     * The IsResumeEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsResumeEnabled;
    /**
     * The IsValidLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsValidLogin;
    /**
     * The IsWebEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsWebEnabled;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for LoginDetail
     * @uses LoginDetail::setFullName()
     * @uses LoginDetail::setIdentifier()
     * @uses LoginDetail::setIsAvalabilityEnabled()
     * @uses LoginDetail::setIsClosed()
     * @uses LoginDetail::setIsEmployer()
     * @uses LoginDetail::setIsMember()
     * @uses LoginDetail::setIsResumeEnabled()
     * @uses LoginDetail::setIsValidLogin()
     * @uses LoginDetail::setIsWebEnabled()
     * @uses LoginDetail::setPassword()
     * @uses LoginDetail::setStatus()
     * @uses LoginDetail::setUserName()
     * @param string $fullName
     * @param int $identifier
     * @param bool $isAvalabilityEnabled
     * @param bool $isClosed
     * @param bool $isEmployer
     * @param bool $isMember
     * @param bool $isResumeEnabled
     * @param bool $isValidLogin
     * @param bool $isWebEnabled
     * @param string $password
     * @param string $status
     * @param string $userName
     */
    public function __construct($fullName = null, $identifier = null, $isAvalabilityEnabled = null, $isClosed = null, $isEmployer = null, $isMember = null, $isResumeEnabled = null, $isValidLogin = null, $isWebEnabled = null, $password = null, $status = null, $userName = null)
    {
        $this
            ->setFullName($fullName)
            ->setIdentifier($identifier)
            ->setIsAvalabilityEnabled($isAvalabilityEnabled)
            ->setIsClosed($isClosed)
            ->setIsEmployer($isEmployer)
            ->setIsMember($isMember)
            ->setIsResumeEnabled($isResumeEnabled)
            ->setIsValidLogin($isValidLogin)
            ->setIsWebEnabled($isWebEnabled)
            ->setPassword($password)
            ->setStatus($status)
            ->setUserName($userName);
    }
    /**
     * Get FullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullName()
    {
        return isset($this->FullName) ? $this->FullName : null;
    }
    /**
     * Set FullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullName
     * @return \StructType\LoginDetail
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        if (is_null($fullName) || (is_array($fullName) && empty($fullName))) {
            unset($this->FullName);
        } else {
            $this->FullName = $fullName;
        }
        return $this;
    }
    /**
     * Get Identifier value
     * @return int|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param int $identifier
     * @return \StructType\LoginDetail
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: int
        if (!is_null($identifier) && !(is_int($identifier) || ctype_digit($identifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get IsAvalabilityEnabled value
     * @return bool|null
     */
    public function getIsAvalabilityEnabled()
    {
        return $this->IsAvalabilityEnabled;
    }
    /**
     * Set IsAvalabilityEnabled value
     * @param bool $isAvalabilityEnabled
     * @return \StructType\LoginDetail
     */
    public function setIsAvalabilityEnabled($isAvalabilityEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvalabilityEnabled) && !is_bool($isAvalabilityEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvalabilityEnabled, true), gettype($isAvalabilityEnabled)), __LINE__);
        }
        $this->IsAvalabilityEnabled = $isAvalabilityEnabled;
        return $this;
    }
    /**
     * Get IsClosed value
     * @return bool|null
     */
    public function getIsClosed()
    {
        return $this->IsClosed;
    }
    /**
     * Set IsClosed value
     * @param bool $isClosed
     * @return \StructType\LoginDetail
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        $this->IsClosed = $isClosed;
        return $this;
    }
    /**
     * Get IsEmployer value
     * @return bool|null
     */
    public function getIsEmployer()
    {
        return $this->IsEmployer;
    }
    /**
     * Set IsEmployer value
     * @param bool $isEmployer
     * @return \StructType\LoginDetail
     */
    public function setIsEmployer($isEmployer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEmployer) && !is_bool($isEmployer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEmployer, true), gettype($isEmployer)), __LINE__);
        }
        $this->IsEmployer = $isEmployer;
        return $this;
    }
    /**
     * Get IsMember value
     * @return bool|null
     */
    public function getIsMember()
    {
        return $this->IsMember;
    }
    /**
     * Set IsMember value
     * @param bool $isMember
     * @return \StructType\LoginDetail
     */
    public function setIsMember($isMember = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMember) && !is_bool($isMember)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMember, true), gettype($isMember)), __LINE__);
        }
        $this->IsMember = $isMember;
        return $this;
    }
    /**
     * Get IsResumeEnabled value
     * @return bool|null
     */
    public function getIsResumeEnabled()
    {
        return $this->IsResumeEnabled;
    }
    /**
     * Set IsResumeEnabled value
     * @param bool $isResumeEnabled
     * @return \StructType\LoginDetail
     */
    public function setIsResumeEnabled($isResumeEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResumeEnabled) && !is_bool($isResumeEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResumeEnabled, true), gettype($isResumeEnabled)), __LINE__);
        }
        $this->IsResumeEnabled = $isResumeEnabled;
        return $this;
    }
    /**
     * Get IsValidLogin value
     * @return bool|null
     */
    public function getIsValidLogin()
    {
        return $this->IsValidLogin;
    }
    /**
     * Set IsValidLogin value
     * @param bool $isValidLogin
     * @return \StructType\LoginDetail
     */
    public function setIsValidLogin($isValidLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValidLogin) && !is_bool($isValidLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValidLogin, true), gettype($isValidLogin)), __LINE__);
        }
        $this->IsValidLogin = $isValidLogin;
        return $this;
    }
    /**
     * Get IsWebEnabled value
     * @return bool|null
     */
    public function getIsWebEnabled()
    {
        return $this->IsWebEnabled;
    }
    /**
     * Set IsWebEnabled value
     * @param bool $isWebEnabled
     * @return \StructType\LoginDetail
     */
    public function setIsWebEnabled($isWebEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWebEnabled) && !is_bool($isWebEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWebEnabled, true), gettype($isWebEnabled)), __LINE__);
        }
        $this->IsWebEnabled = $isWebEnabled;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\LoginDetail
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\LoginDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\LoginDetail
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoginDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
