<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DbActionBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DbActionBase
 * @subpackage Structs
 */
class DbActionBase extends AbstractStructBase
{
    /**
     * The ConnectionString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConnectionString;
    /**
     * Constructor method for DbActionBase
     * @uses DbActionBase::setConnectionString()
     * @param string $connectionString
     */
    public function __construct($connectionString = null)
    {
        $this
            ->setConnectionString($connectionString);
    }
    /**
     * Get ConnectionString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectionString()
    {
        return isset($this->ConnectionString) ? $this->ConnectionString : null;
    }
    /**
     * Set ConnectionString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectionString
     * @return \StructType\DbActionBase
     */
    public function setConnectionString($connectionString = null)
    {
        // validation for constraint: string
        if (!is_null($connectionString) && !is_string($connectionString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionString, true), gettype($connectionString)), __LINE__);
        }
        if (is_null($connectionString) || (is_array($connectionString) && empty($connectionString))) {
            unset($this->ConnectionString);
        } else {
            $this->ConnectionString = $connectionString;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DbActionBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
