<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberUpdate StructType
 * @subpackage Structs
 */
class MemberUpdate extends AbstractStructBase
{
    /**
     * The webServiceCredentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceCredential
     */
    public $webServiceCredentials;
    /**
     * The member
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Member
     */
    public $member;
    /**
     * Constructor method for MemberUpdate
     * @uses MemberUpdate::setWebServiceCredentials()
     * @uses MemberUpdate::setMember()
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @param \StructType\Member $member
     */
    public function __construct(\StructType\ServiceCredential $webServiceCredentials = null, \StructType\Member $member = null)
    {
        $this
            ->setWebServiceCredentials($webServiceCredentials)
            ->setMember($member);
    }
    /**
     * Get webServiceCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceCredential|null
     */
    public function getWebServiceCredentials()
    {
        return isset($this->webServiceCredentials) ? $this->webServiceCredentials : null;
    }
    /**
     * Set webServiceCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @return \StructType\MemberUpdate
     */
    public function setWebServiceCredentials(\StructType\ServiceCredential $webServiceCredentials = null)
    {
        if (is_null($webServiceCredentials) || (is_array($webServiceCredentials) && empty($webServiceCredentials))) {
            unset($this->webServiceCredentials);
        } else {
            $this->webServiceCredentials = $webServiceCredentials;
        }
        return $this;
    }
    /**
     * Get member value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Member|null
     */
    public function getMember()
    {
        return isset($this->member) ? $this->member : null;
    }
    /**
     * Set member value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Member $member
     * @return \StructType\MemberUpdate
     */
    public function setMember(\StructType\Member $member = null)
    {
        if (is_null($member) || (is_array($member) && empty($member))) {
            unset($this->member);
        } else {
            $this->member = $member;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
