<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invoice ServiceType
 * @subpackage Services
 */
class Invoice extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InvoiceByMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InvoiceByMember $parameters
     * @return \StructType\InvoiceByMemberResponse|bool
     */
    public function InvoiceByMember(\StructType\InvoiceByMember $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InvoiceByMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InvoiceByMemberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
